/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import traben.entity_model_features.models.animation.EMFAttachments;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFSpriteData;
import traben.entity_model_features.utils.EMFUtils;

public class EMFPartData {
    public String texture = "";
    public int[] textureSize = null;
    public String invertAxis = "";
    public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
    public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};
    public String mirrorTexture = "";
    public EMFBoxData[] boxes = new EMFBoxData[0];
    public EMFSpriteData[] sprites = new EMFSpriteData[0];
    public EMFPartData submodel = null;
    public LinkedList<EMFPartData> submodels = new LinkedList();
    public String baseId = "";
    public String model = "";
    public String id = "";
    public String part = null;
    public boolean attach = false;
    public float scale = 1.0f;
    public Object2ObjectOpenHashMap<String, float[]> attachments = new Object2ObjectOpenHashMap();
    public LinkedList<LinkedHashMap<String, String>> animations = null;
    private class_2960 customTexture = null;

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EMFPartData partData = (EMFPartData)o;
        return this.attach == partData.attach && Float.compare(partData.scale, this.scale) == 0 && Objects.equals(this.texture, partData.texture) && Arrays.equals(this.textureSize, partData.textureSize) && Objects.equals(this.invertAxis, partData.invertAxis) && Arrays.equals(this.translate, partData.translate) && Arrays.equals(this.rotate, partData.rotate) && Objects.equals(this.mirrorTexture, partData.mirrorTexture) && Arrays.equals(this.boxes, partData.boxes) && Arrays.equals(this.sprites, partData.sprites) && Objects.equals(this.submodel, partData.submodel) && Objects.equals(this.submodels, partData.submodels) && Objects.equals(this.baseId, partData.baseId) && Objects.equals(this.model, partData.model) && Objects.equals(this.id, partData.id) && Objects.equals(this.part, partData.part) && Objects.equals(this.animations, partData.animations) && Objects.equals(this.customTexture, partData.customTexture);
    }

    public int hashCode() {
        int result = Objects.hash(this.texture, this.invertAxis, this.mirrorTexture, this.submodel, this.submodels, this.baseId, this.model, this.id, this.part, this.attach, Float.valueOf(this.scale), this.customTexture, this.animations);
        result = 31 * result + Arrays.hashCode(this.textureSize);
        result = 31 * result + Arrays.hashCode(this.translate);
        result = 31 * result + Arrays.hashCode(this.rotate);
        result = 31 * result + Arrays.hashCode(this.boxes);
        result = 31 * result + Arrays.hashCode(this.sprites);
        return result;
    }

    private void copyFrom(EMFPartData jpmModel) {
        if (this.submodels.isEmpty()) {
            this.submodels = jpmModel.submodels;
        }
        if (this.submodel == null) {
            this.submodel = jpmModel.submodel;
        }
        if (this.textureSize == null) {
            this.textureSize = jpmModel.textureSize;
        }
        if (this.texture.isBlank()) {
            this.texture = jpmModel.texture;
        }
        if (this.invertAxis.isBlank()) {
            this.invertAxis = jpmModel.invertAxis;
        }
        if (this.translate[0] == 0.0f && this.translate[1] == 0.0f && this.translate[2] == 0.0f) {
            this.translate = jpmModel.translate;
        }
        if (this.rotate[0] == 0.0f && this.rotate[1] == 0.0f && this.rotate[2] == 0.0f) {
            this.rotate = jpmModel.rotate;
        }
        if (this.mirrorTexture.isBlank()) {
            this.mirrorTexture = jpmModel.mirrorTexture;
        }
        if (this.boxes.length == 0) {
            this.boxes = jpmModel.boxes;
        }
        if (this.sprites.length == 0) {
            this.sprites = jpmModel.sprites;
        }
        if (this.scale == 1.0f) {
            this.scale = jpmModel.scale;
        }
        if (this.animations == null || this.animations.isEmpty()) {
            this.animations = jpmModel.animations;
        }
        if (this.baseId.isBlank()) {
            this.baseId = jpmModel.baseId;
        }
    }

    public List<Consumer<class_4587>> getAttachments() {
        ArrayList<Consumer<class_4587>> list = new ArrayList<Consumer<class_4587>>();
        for (String s : this.attachments.keySet()) {
            float[] floats = (float[])this.attachments.get((Object)s);
            try {
                boolean invX = this.invertAxis.contains("x");
                boolean invY = this.invertAxis.contains("y");
                boolean invZ = this.invertAxis.contains("z");
                if (floats == null || floats.length != 3) continue;
                EMFAttachments attachment = EMFAttachments.valueOf(s);
                list.add(attachment.getConsumerWithTranslates(floats[0] * (float)(invX ? -1 : 1), floats[1] * (float)(invY ? -1 : 1), floats[2] * (float)(invZ ? -1 : 1)));
            }
            catch (IllegalArgumentException e) {
                EMFUtils.log("Unknown attachment point: " + s);
            }
        }
        return list;
    }

    public void prepare(int[] textureSize, EMFJemData jem, class_2960 jemTexture) {
        EMFPartData jpmModel;
        this.id = this.id.isBlank() ? "EMF_" + this.hashCode() : "EMF_" + this.id;
        if (!this.model.isEmpty() && (jpmModel = EMFUtils.readModelPart(this.model, jem.getFilePath())) != null) {
            this.copyFrom(jpmModel);
        }
        if (this.textureSize == null || this.textureSize.length != 2) {
            this.textureSize = textureSize;
        }
        this.customTexture = jem.validateJemTexture(this.texture);
        if (this.customTexture == null) {
            this.customTexture = jemTexture;
        }
        boolean invX = this.invertAxis.contains("x");
        boolean invY = this.invertAxis.contains("y");
        boolean invZ = this.invertAxis.contains("z");
        float translateX = this.translate[0];
        float translateY = this.translate[1];
        float translateZ = this.translate[2];
        float rotateX = (float)Math.toRadians(this.rotate[0]);
        float rotateY = (float)Math.toRadians(this.rotate[1]);
        float rotateZ = (float)Math.toRadians(this.rotate[2]);
        if (invX) {
            rotateX = -rotateX;
            translateX = -translateX;
        }
        if (invY) {
            rotateY = -rotateY;
            translateY = -translateY;
        }
        if (invZ) {
            rotateZ = -rotateZ;
            translateZ = -translateZ;
        }
        this.translate[0] = translateX;
        this.translate[1] = translateY;
        this.translate[2] = translateZ;
        this.rotate[0] = rotateX;
        this.rotate[1] = rotateY;
        this.rotate[2] = rotateZ;
        for (EMFBoxData box : this.boxes) {
            box.prepare(invX, invY, invZ);
        }
        for (EMFSpriteData sprite : this.sprites) {
            sprite.prepare();
        }
        if (this.submodel != null) {
            this.submodel.prepare(this.textureSize, jem, null);
            if (!this.submodels.contains(this.submodel)) {
                this.submodels.add(this.submodel);
                this.submodel = null;
            }
        }
        for (EMFPartData model : this.submodels) {
            model.prepare(this.textureSize, jem, null);
        }
    }

    public String toString() {
        return "modelData{ id='" + this.id + "', part='" + this.part + "', submodels=" + this.submodels.size() + "', anims=" + String.valueOf(this.animations == null ? "0" : Integer.valueOf(this.animations.size())) + "}";
    }

    public static class EMFPartPrinter {
        public String texture = "";
        public int[] textureSize = null;
        public String invertAxis = "xy";
        public float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};
        public String mirrorTexture = "";
        public EMFBoxData.EMFBoxPrinter[] boxes = new EMFBoxData.EMFBoxPrinter[0];
        public EMFSpriteData[] sprites = new EMFSpriteData[0];
        public EMFPartPrinter submodel = null;
        public LinkedList<EMFPartPrinter> submodels = new LinkedList();
        public String baseId = "";
        public String model = "";
        public String id = "";
        public String part = null;
        public boolean attach = false;
        public float scale = 1.0f;
        public LinkedHashMap<String, String>[] animations = new LinkedHashMap[0];
    }
}

