/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.api.DerivedBlock;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class PFDebugHud {
    private final SoundEngine engine;
    private final List<String> list = new ArrayList<String>();

    PFDebugHud(SoundEngine engine) {
        this.engine = engine;
    }

    public void render(class_239 blockHit, class_239 fluidHit, List<String> finalList) {
        class_3966 ehr;
        class_239 class_2392;
        class_310 client = class_310.method_1551();
        this.list.add("");
        this.list.add(String.valueOf(class_124.field_1073) + "Presence Footsteps " + String.valueOf(((ModContainer)FabricLoader.getInstance().getModContainer("presencefootsteps").get()).getMetadata().getVersion()));
        PFConfig config = this.engine.getConfig();
        this.list.add(String.format("Enabled: %s, Multiplayer: %s, Running: %s", config.getEnabled(), config.getEnabledMP(), this.engine.isRunning(client)));
        this.list.add(String.format("Volume: Global[G: %s%%, W: %s%%, F: %s%%]", config.getGlobalVolume(), config.wetSoundsVolume, config.foliageSoundsVolume));
        this.list.add(String.format("Entities[H: %s%%, P: %s%%], Players[U: %s%%, T: %s%% ]", config.hostileEntitiesVolume, config.passiveEntitiesVolume, config.clientPlayerVolume, config.otherPlayerVolume));
        this.list.add(String.format("Stepping Mode: %s, Targeting Mode: %s, Footwear: %s", config.getLocomotion() == Locomotion.NONE ? String.format("AUTO (%sDETECTED %s%s)", new Object[]{class_124.field_1067, Locomotion.forPlayer((class_1657)client.field_1724, Locomotion.NONE), class_124.field_1070}) : config.getLocomotion(), config.getEntitySelector(), config.getEnabledFootwear()));
        this.list.add(String.format("Data Loaded: B%s P%s G%s", this.engine.getIsolator().blocks().getSubstrates().size(), this.engine.getIsolator().primitives().getSubstrates().size(), this.engine.getIsolator().golems().getSubstrates().size()));
        this.list.add(String.format("Has Resource Pack: %s%s", this.engine.hasData() ? class_124.field_1060 : class_124.field_1061, this.engine.hasData()));
        PFDebugHud.insertAt(this.list, finalList, "Targeted Block: ", -1);
        if (blockHit.method_17783() == class_239.class_240.field_1332) {
            boolean hasWater;
            class_2338 pos = ((class_3965)blockHit).method_17777();
            class_2680 state = client.field_1687.method_8320(pos);
            this.list.add("");
            this.list.add(String.valueOf(class_124.field_1073) + "Targeted Block Sounds Like");
            class_2680 base = DerivedBlock.getBaseOf(state);
            if (!base.method_26215()) {
                this.list.add(class_7923.field_41175.method_10221((Object)base.method_26204()).toString());
            }
            this.list.add(String.format(Locale.ENGLISH, "Primitive Key: %s", PrimitiveLookup.getKey(state.method_26231())));
            class_2338 above = pos.method_10084();
            boolean hasRain = client.field_1687.method_8419() && ((class_1959)client.field_1687.method_23753(above).comp_349()).method_48162(above) == class_1959.class_1963.field_9382;
            boolean hasLava = client.field_1687.method_8320(above).method_26227().method_15767(class_3486.field_15518);
            boolean bl = hasWater = client.field_1687.method_8520(above) || state.method_26227().method_15767(class_3486.field_15517) || client.field_1687.method_8320(above).method_26227().method_15767(class_3486.field_15517);
            this.list.add("Surface Condition: " + (hasLava ? String.valueOf(class_124.field_1061) + "LAVA" : (hasWater ? String.valueOf(class_124.field_1078) + "WET" : (hasRain ? String.valueOf(class_124.field_1080) + "SHELTERED" : String.valueOf(class_124.field_1080) + "DRY"))));
            this.renderSoundList("Step Sounds[B]", this.engine.getIsolator().blocks().getAssociations(state), this.list);
            this.renderSoundList("Step Sounds[P]", this.engine.getIsolator().primitives().getAssociations(state.method_26231().method_10594()), this.list);
            this.list.add("");
            PFDebugHud.insertAt(this.list, finalList, "Targeted Block: ", 1);
        }
        if ((class_2392 = client.field_1765) instanceof class_3966 && (ehr = (class_3966)class_2392).method_17782() != null) {
            this.list.add(String.format("Targeted Entity Step Mode: %s", new Object[]{this.engine.getIsolator().locomotions().lookup(ehr.method_17782())}));
            this.renderSoundList("Step Sounds[G]", this.engine.getIsolator().golems().getAssociations(ehr.method_17782().method_5864()), this.list);
            PFDebugHud.insertAt(this.list, finalList, "Targeted Entity", 3);
        }
    }

    private static void insertAt(List<String> values, List<String> destination, String target, int offset) {
        int i;
        for (i = 0; i < destination.size() && destination.get(i).indexOf(target) == -1; ++i) {
        }
        destination.addAll(class_3532.method_15340((int)(i + offset), (int)0, (int)destination.size()), values);
        values.clear();
    }

    private void renderSoundList(String title, Map<String, SoundsKey> sounds, List<String> list) {
        if (sounds.isEmpty()) {
            return;
        }
        StringBuilder combinedList = new StringBuilder(String.valueOf(class_124.field_1073) + title + String.valueOf(class_124.field_1070) + ": [ ");
        boolean first = true;
        for (Map.Entry<String, SoundsKey> entry : sounds.entrySet()) {
            if (!first) {
                combinedList.append(" / ");
            }
            first = false;
            if (!entry.getKey().isEmpty()) {
                combinedList.append(entry.getKey()).append(":");
            }
            combinedList.append(entry.getValue().raw());
        }
        combinedList.append(" ]");
        list.add(combinedList.toString());
        if (!list.isEmpty()) {
            return;
        }
        if (sounds.isEmpty()) {
            list.add(SoundsKey.UNASSIGNED.raw());
        } else {
            sounds.forEach((key, value) -> list.add((key.isEmpty() ? "default" : key) + ": " + value.raw()));
        }
    }
}

