/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.crend.dynamiccrosshair.AutoHudCompat;
import mod.crend.dynamiccrosshair.component.CrosshairComponent;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(int argb, boolean enableBlend) {
        float alphaMultiplier = 1.0f;
        if (autoHudCompat) {
            alphaMultiplier = AutoHudCompat.getAlpha();
        }
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f * alphaMultiplier;
        RenderSystem.setShaderColor((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)alpha);
        if (!enableBlend || autoHudCompat && alphaMultiplier < 0.9f) {
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
    }

    public static void preRender() {
        CrosshairStyle defaultStyle = CrosshairHandler.getDefaultCrosshair();
        CrosshairRenderer.setColor(defaultStyle.color(), defaultStyle.enableBlend());
    }

    public static void fixCenteredCrosshairPre(class_332 context, int x, int y) {
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        double i = (double)window.method_4489() / scale;
        double j = (double)window.method_4506() / scale;
        double dx = (i - 15.0) / 2.0 - (double)x;
        double dy = (j - 15.0) / 2.0 - (double)y;
        context.method_51448().method_22903();
        context.method_51448().method_22904(dx, dy, 0.0);
    }

    public static void fixCenteredCrosshairPost(class_332 context) {
        context.method_51448().method_22909();
    }

    public static void renderCrosshair(class_332 context, class_2960 style, int x, int y) {
        CrosshairStyleManager.INSTANCE.get(style).draw(context, x, y);
    }

    public static void render(class_332 context, int x, int y) {
        CrosshairComponent crosshair = CrosshairHandler.getActiveCrosshair();
        CrosshairStyle primaryStyle = crosshair.getPrimaryStyle();
        CrosshairStyle secondaryStyle = crosshair.getSecondaryStyle();
        if (primaryStyle != null) {
            CrosshairRenderer.setColor(primaryStyle.color(), primaryStyle.enableBlend());
            CrosshairRenderer.renderCrosshair(context, primaryStyle.identifier(), x, y);
        } else if (CrosshairHandler.forceShowCrosshair && secondaryStyle == null) {
            CrosshairStyle crosshairStyle = CrosshairComponent.FORCE_CROSSHAIR.getPrimaryStyle();
            CrosshairRenderer.setColor(crosshairStyle.color(), crosshairStyle.enableBlend());
            CrosshairRenderer.renderCrosshair(context, crosshairStyle.identifier(), x, y);
        }
        if (secondaryStyle != null) {
            CrosshairRenderer.setColor(secondaryStyle.color(), secondaryStyle.enableBlend());
            CrosshairRenderer.renderCrosshair(context, secondaryStyle.identifier(), x, y);
        }
        for (CrosshairStyle modifier : crosshair.getModifiers()) {
            CrosshairRenderer.setColor(modifier.color(), modifier.enableBlend());
            CrosshairRenderer.renderCrosshair(context, modifier.identifier(), x, y);
        }
    }

    public static void postRender() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }
}

