/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config;

import java.util.Collections;
import java.util.List;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.Config;
import mod.crend.dynamiccrosshair.config.ConfigUpdater;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import mod.crend.libbamboo.opt.ConfigStore;
import mod.crend.libbamboo.type.BlockOrTag;
import mod.crend.libbamboo.type.ItemOrTag;

public class ConfigHandler {
    public static final ConfigStore<Config> CONFIG_STORE = new ConfigStore(Config.class, (mod.crend.libbamboo.opt.ConfigUpdater)new ConfigUpdater());

    public ConfigHandler() {
        CONFIG_STORE.config();
    }

    public boolean isDynamicCrosshair() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).dynamicCrosshair;
    }

    public boolean isDisableDebugCrosshair() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).disableDebugCrosshair;
    }

    public boolean isThirdPersonCrosshair() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).thirdPersonCrosshair;
    }

    public boolean isHideWithScreen() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hideWithScreen;
    }

    public boolean isHideWithMap() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).hideWithMap;
    }

    public boolean isFixCenteredCrosshair() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).fixCenteredCrosshair;
    }

    public boolean dynamicCrosshairOnBlock() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.onBlock;
    }

    public boolean dynamicCrosshairOnInteractableBlock() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.onInteractableBlock;
    }

    public boolean dynamicCrosshairOnEntity() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.onEntity;
    }

    public CrosshairPolicy dynamicCrosshairHoldingTool() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingTool;
    }

    public boolean dynamicCrosshairDisplayCorrectTool() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.displayCorrectTool;
    }

    public boolean dynamicCrosshairHoldingMeleeWeapon() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingMeleeWeapon;
    }

    public boolean dynamicCrosshairMeleeWeaponOnEntity() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.meleeWeaponOnEntity;
    }

    public boolean dynamicCrosshairMeleeWeaponOnBreakableBlock() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.meleeWeaponOnBreakableBlock;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingRangedWeapon() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingRangedWeapon;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingThrowable() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingThrowable;
    }

    public boolean dynamicCrosshairHoldingShield() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingShield;
    }

    public BlockCrosshairPolicy dynamicCrosshairHoldingBlock() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingBlock;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingUsableItem() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.holdingUsableItem;
    }

    public boolean dynamicCrosshairForceHoldingSpyglass() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).crosshairConfig.forceHoldingSpyglass;
    }

    public CrosshairStyle getDefaultStyle() {
        return new CrosshairStyle(DynamicCrosshairStyles.DEFAULT, ((Config)ConfigHandler.CONFIG_STORE.config()).color.overrideColor ? ((Config)ConfigHandler.CONFIG_STORE.config()).color.customColor.getRGB() : -1, ((Config)ConfigHandler.CONFIG_STORE.config()).color.enableBlend, true);
    }

    public boolean isDynamicCrosshairStyle() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).dynamicCrosshairStyle;
    }

    private CrosshairStyle configToCrosshairStyle(Config.CrosshairStyleSettings cfg) {
        return new CrosshairStyle(cfg.style, cfg.overrideColor ? cfg.customColor.getRGB() : this.getDefaultStyle().color(), cfg.enableBlend, cfg.coalesce);
    }

    public CrosshairStyle getCrosshairStyleRegular() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.regular);
    }

    public CrosshairStyle getCrosshairStyleOnBlock() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.onBlock);
    }

    public CrosshairStyle getCrosshairStyleOnEntity() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.onEntity);
    }

    public CrosshairStyle getCrosshairStyleHoldingTool() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.holdingTool);
    }

    public CrosshairStyle getCrosshairStyleHoldingMeleeWeapon() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.holdingMeleeWeapon);
    }

    public CrosshairStyle getCrosshairStyleHoldingRangedWeapon() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.holdingRangedWeapon);
    }

    public CrosshairStyle getCrosshairStyleHoldingThrowable() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.holdingThrowable);
    }

    public CrosshairStyle getCrosshairStyleHoldingBlock() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.holdingBlock);
    }

    public CrosshairStyle getCrosshairStyleInteractable() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.interact);
    }

    public CrosshairStyle getCrosshairStyleUsableItem() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.useItem);
    }

    public CrosshairStyle getCrosshairStyleShield() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairStyle.shield);
    }

    public CrosshairStyle getCrosshairModifierCorrectTool() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairModifiers.modCorrectTool);
    }

    public CrosshairStyle getCrosshairModifierIncorrectTool() {
        return this.configToCrosshairStyle(((Config)ConfigHandler.CONFIG_STORE.config()).crosshairModifiers.modIncorrectTool);
    }

    public boolean isTweaksEnabled() {
        return ((Config)ConfigHandler.CONFIG_STORE.config()).enableTweaks;
    }

    public List<ItemOrTag> getAdditionalTools() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalTools;
    }

    public List<ItemOrTag> getAdditionalMeleeWeapons() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalMeleeWeapons;
    }

    public List<ItemOrTag> getAdditionalRangedWeapons() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalRangedWeapons;
    }

    public List<ItemOrTag> getAdditionalThrowables() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalThrowables;
    }

    public List<ItemOrTag> getAdditionalUsableItems() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalUsableItems;
    }

    public List<BlockOrTag> getAdditionalInteractableBlocks() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        return ((Config)ConfigHandler.CONFIG_STORE.config()).additionalInteractableBlocks;
    }
}

