/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.Vector;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.TextureHelper;
import squeek.appleskin.util.IntPoint;

public class HUDOverlayHandler {
    public static HUDOverlayHandler INSTANCE;
    private float unclampedFlashAlpha = 0.0f;
    private float flashAlpha = 0.0f;
    private byte alphaDir = 1;
    private boolean needDisableBlend = false;
    public final OffsetsCache barOffsets = new OffsetsCache();
    public final HeldFoodCache heldFood = new HeldFoodCache();

    public static void init() {
        INSTANCE = new HUDOverlayHandler();
    }

    public void onPreRenderFood(class_332 context, class_1657 player, int top, int right) {
        if (ModConfig.INSTANCE == null) {
            return;
        }
        if (!ModConfig.INSTANCE.showFoodExhaustionHudUnderlay) {
            return;
        }
        assert (player != null);
        float exhaustion = player.method_7344().method_35219();
        HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top, context);
        ((EventHandler)HUDOverlayEvent.Exhaustion.EVENT.invoker()).interact(renderEvent);
        if (!renderEvent.isCanceled) {
            this.drawExhaustionOverlay(renderEvent, 1.0f);
        }
    }

    public void onRenderFood(class_332 context, class_1657 player, int top, int right) {
        FoodHelper.QueriedFoodResult result;
        if (ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldRenderAnyOverlays()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        assert (player != null);
        class_1702 stats = player.method_7344();
        HUDOverlayEvent.Saturation saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.method_7589(), right, top, context);
        if (!ModConfig.INSTANCE.showSaturationHudOverlay) {
            saturationRenderEvent.isCanceled = true;
        }
        if (!saturationRenderEvent.isCanceled) {
            ((EventHandler)HUDOverlayEvent.Saturation.EVENT.invoker()).interact(saturationRenderEvent);
        }
        if (!saturationRenderEvent.isCanceled) {
            this.drawSaturationOverlay(saturationRenderEvent, mc, 0.0f, 1.0f, mc.field_1705.method_1738());
        }
        if ((result = this.heldFood.result(mc.field_1705.method_1738(), player)) == null) {
            this.resetFlash();
            return;
        }
        if (ModConfig.INSTANCE.showFoodValuesHudOverlay) {
            HUDOverlayEvent.HungerRestored hungerRenderEvent = new HUDOverlayEvent.HungerRestored(stats.method_7586(), result.itemStack, result.modifiedFoodComponent, right, top, context);
            ((EventHandler)HUDOverlayEvent.HungerRestored.EVENT.invoker()).interact(hungerRenderEvent);
            if (hungerRenderEvent.isCanceled) {
                return;
            }
            int foodHunger = result.modifiedFoodComponent.comp_2491();
            float foodSaturationIncrement = result.modifiedFoodComponent.comp_2492();
            this.drawHungerOverlay(hungerRenderEvent, mc, foodHunger, this.flashAlpha, FoodHelper.isRotten(result.modifiedFoodComponent), mc.field_1705.method_1738());
            int newFoodValue = stats.method_7586() + foodHunger;
            float newSaturationValue = stats.method_7589() + foodSaturationIncrement;
            if (!saturationRenderEvent.isCanceled) {
                float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.method_7589() : foodSaturationIncrement;
                this.drawSaturationOverlay(saturationRenderEvent, mc, saturationGained, this.flashAlpha, mc.field_1705.method_1738());
            }
        }
    }

    public void onRenderHealth(class_332 context, class_1657 player, int left, int top, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking) {
        if (ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldRenderAnyOverlays()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        assert (player != null);
        FoodHelper.QueriedFoodResult result = this.heldFood.result(mc.field_1705.method_1738(), player);
        if (result == null) {
            this.resetFlash();
            return;
        }
        if (this.shouldShowEstimatedHealth(player, mc.field_1705.method_1738())) {
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(player, result.modifiedFoodComponent);
            float currentHealth = player.method_6032();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.method_6063());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, result.itemStack, result.modifiedFoodComponent, left, top, context);
            }
            if (healthRenderEvent != null) {
                ((EventHandler)HUDOverlayEvent.HealthRestored.EVENT.invoker()).interact(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled) {
                this.drawHealthOverlay(healthRenderEvent, mc, this.flashAlpha, mc.field_1705.method_1738());
            }
        }
    }

    public void drawSaturationOverlay(class_332 context, float saturationGained, float saturationLevel, class_310 mc, int right, int top, float alpha, int guiTicks) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        this.enableAlpha(alpha);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        Vector<IntPoint> foodBarOffsets = this.barOffsets.foodBarOffsets(guiTicks, (class_1657)mc.field_1724);
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            context.method_25302(TextureHelper.MOD_ICONS, x, y, u, v, iconSize, iconSize);
        }
        this.disableAlpha(alpha);
    }

    public void drawHungerOverlay(class_332 context, int hungerRestored, int foodLevel, class_310 mc, int right, int top, float alpha, boolean useRottenTextures, int guiTicks) {
        if (hungerRestored <= 0) {
            return;
        }
        this.enableAlpha(alpha);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconSize = 9;
        Vector<IntPoint> foodBarOffsets = this.barOffsets.foodBarOffsets(guiTicks, (class_1657)mc.field_1724);
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            class_2960 backgroundSprite = TextureHelper.getFoodTexture(useRottenTextures, TextureHelper.FoodType.EMPTY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            context.method_52706(backgroundSprite, x, y, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            boolean isHalf = i * 2 + 1 == modifiedFood;
            class_2960 iconSprite = TextureHelper.getFoodTexture(useRottenTextures, isHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
            context.method_52706(iconSprite, x, y, iconSize, iconSize);
        }
        this.disableAlpha(alpha);
    }

    public void drawHealthOverlay(class_332 context, float health, float modifiedHealth, class_310 mc, int right, int top, float alpha, int guiTicks) {
        if (modifiedHealth <= health) {
            return;
        }
        this.enableAlpha(alpha);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = mc.field_1724.method_37908() != null && mc.field_1724.method_37908().method_8401().method_152();
        int startHealthBars = (int)Math.max(0.0, Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.max(0.0, Math.ceil(modifiedHealth / 2.0f));
        int iconSize = 9;
        Vector<IntPoint> healthBarOffsets = this.barOffsets.healthBarOffsets(guiTicks, (class_1657)mc.field_1724);
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset = healthBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            class_2960 backgroundSprite = TextureHelper.getHeartTexture(isHardcore, TextureHelper.HeartType.CONTAINER);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            context.method_52706(backgroundSprite, x, y, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            boolean isHalf = i * 2 + 1 == fixedModifiedHealth;
            class_2960 iconSprite = TextureHelper.getHeartTexture(isHardcore, isHalf ? TextureHelper.HeartType.HALF : TextureHelper.HeartType.FULL);
            context.method_52706(iconSprite, x, y, iconSize, iconSize);
        }
        this.disableAlpha(alpha);
    }

    public void drawExhaustionOverlay(class_332 context, float exhaustion, int right, int top, float alpha) {
        float maxExhaustion = FoodHelper.MAX_EXHAUSTION;
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        this.enableAlpha(0.75f);
        context.method_25302(TextureHelper.MOD_ICONS, right - width, top, 81 - width, 18, width, height);
        this.disableAlpha(0.75f);
    }

    private void drawSaturationOverlay(HUDOverlayEvent.Saturation event, class_310 mc, float saturationGained, float alpha, int guiTicks) {
        this.drawSaturationOverlay(event.context, saturationGained, event.saturationLevel, mc, event.x, event.y, alpha, guiTicks);
    }

    private void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, class_310 mc, int hunger, float alpha, boolean useRottenTextures, int guiTicks) {
        this.drawHungerOverlay(event.context, hunger, event.currentFoodLevel, mc, event.x, event.y, alpha, useRottenTextures, guiTicks);
    }

    private void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, class_310 mc, float alpha, int guiTicks) {
        this.drawHealthOverlay(event.context, mc.field_1724.method_6032(), event.modifiedHealth, mc, event.x, event.y, alpha, guiTicks);
    }

    private void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, float alpha) {
        this.drawExhaustionOverlay(event.context, event.exhaustion, event.x, event.y, alpha);
    }

    private boolean shouldRenderAnyOverlays() {
        return ModConfig.INSTANCE.showFoodValuesHudOverlay || ModConfig.INSTANCE.showSaturationHudOverlay || ModConfig.INSTANCE.showFoodHealthHudOverlay;
    }

    private void enableAlpha(float alpha) {
        this.needDisableBlend = !GL11.glIsEnabled((int)3042);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    private void disableAlpha(float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.needDisableBlend) {
            RenderSystem.disableBlend();
        }
    }

    public void onClientTick() {
        this.unclampedFlashAlpha += (float)this.alphaDir * 0.125f;
        if (this.unclampedFlashAlpha >= 1.5f) {
            this.alphaDir = (byte)-1;
        } else if (this.unclampedFlashAlpha <= -0.5f) {
            this.alphaDir = 1;
        }
        this.flashAlpha = Math.max(0.0f, Math.min(1.0f, this.unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ModConfig.INSTANCE.maxHudOverlayFlashAlpha));
    }

    public void resetFlash() {
        this.flashAlpha = 0.0f;
        this.unclampedFlashAlpha = 0.0f;
        this.alphaDir = 1;
    }

    private boolean shouldShowEstimatedHealth(class_1657 player, int guiTicks) {
        if (!ModConfig.INSTANCE.showFoodHealthHudOverlay) {
            return false;
        }
        if (this.barOffsets.healthBarOffsets(guiTicks, player).isEmpty()) {
            return false;
        }
        class_1702 stats = player.method_7344();
        if (player.method_37908().method_8407() == class_1267.field_5801) {
            return false;
        }
        if (stats.method_7586() >= 18) {
            return false;
        }
        if (player.method_6059(class_1294.field_5899)) {
            return false;
        }
        if (player.method_6059(class_1294.field_5920)) {
            return false;
        }
        return !player.method_6059(class_1294.field_5924);
    }

    private static class OffsetsCache {
        protected final Vector<IntPoint> foodBarOffsets = new Vector();
        protected final Vector<IntPoint> healthBarOffsets = new Vector();
        public int lastGuiTick = 0;
        protected final Random random = new Random();

        private OffsetsCache() {
        }

        protected void generate(int guiTicks, class_1657 player) {
            int i;
            float absorptionHealth;
            int preferHealthBars = 10;
            int preferFoodBars = 10;
            float maxHealth = player.method_6063();
            int healthBars = (int)Math.ceil((maxHealth + (absorptionHealth = (float)Math.ceil(player.method_6067()))) / 2.0f);
            if (healthBars < 0 || healthBars > 1000) {
                healthBars = 0;
            }
            int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
            int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
            boolean shouldAnimatedHealth = false;
            boolean shouldAnimatedFood = false;
            if (ModConfig.INSTANCE.showVanillaAnimationsOverlay) {
                class_1702 hungerManager = player.method_7344();
                float saturationLevel = hungerManager.method_7589();
                int foodLevel = hungerManager.method_7586();
                shouldAnimatedFood = saturationLevel <= 0.0f && guiTicks % (foodLevel * 3 + 1) == 0;
                shouldAnimatedHealth = Math.ceil(player.method_6032()) <= 4.0;
            }
            this.random.setSeed(guiTicks * 312871);
            if (this.healthBarOffsets.size() != healthBars) {
                this.healthBarOffsets.setSize(healthBars);
            }
            if (this.foodBarOffsets.size() != 10) {
                this.foodBarOffsets.setSize(10);
            }
            for (i = healthBars - 1; i >= 0; --i) {
                IntPoint point;
                int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
                int x = i % 10 * 8;
                int y = -(row * healthRowHeight);
                if (shouldAnimatedHealth) {
                    y += this.random.nextInt(2);
                }
                if ((point = this.healthBarOffsets.get(i)) == null) {
                    point = new IntPoint();
                    this.healthBarOffsets.set(i, point);
                }
                point.x = x;
                point.y = y;
            }
            for (i = 0; i < 10; ++i) {
                IntPoint point;
                int x = -(i * 8) - 9;
                int y = 0;
                if (shouldAnimatedFood) {
                    y += this.random.nextInt(3) - 1;
                }
                if ((point = this.foodBarOffsets.get(i)) == null) {
                    point = new IntPoint();
                    this.foodBarOffsets.set(i, point);
                }
                point.x = x;
                point.y = y;
            }
        }

        public Vector<IntPoint> healthBarOffsets(int guiTick, class_1657 player) {
            if (guiTick != this.lastGuiTick) {
                this.generate(guiTick, player);
                this.lastGuiTick = guiTick;
            }
            return this.healthBarOffsets;
        }

        public Vector<IntPoint> foodBarOffsets(int guiTicks, class_1657 player) {
            if (guiTicks != this.lastGuiTick) {
                this.generate(guiTicks, player);
                this.lastGuiTick = guiTicks;
            }
            return this.foodBarOffsets;
        }
    }

    public static class HeldFoodCache {
        @Nullable
        protected FoodHelper.QueriedFoodResult result;
        public int lastGuiTick = 0;

        protected void query(class_1657 player) {
            boolean shouldRenderHeldItemValues;
            boolean canConsume;
            class_1799 heldItem = player.method_6047();
            FoodHelper.QueriedFoodResult heldFood = FoodHelper.query(heldItem, player);
            boolean bl = canConsume = heldFood != null && FoodHelper.canConsume(player, heldFood.modifiedFoodComponent);
            if (ModConfig.INSTANCE.showFoodValuesHudOverlayWhenOffhand && !canConsume) {
                heldItem = player.method_6079();
                heldFood = FoodHelper.query(heldItem, player);
                canConsume = heldFood != null && FoodHelper.canConsume(player, heldFood.modifiedFoodComponent);
            }
            boolean bl2 = shouldRenderHeldItemValues = !heldItem.method_7960() && canConsume;
            if (!shouldRenderHeldItemValues) {
                this.result = null;
                return;
            }
            this.result = heldFood;
        }

        public FoodHelper.QueriedFoodResult result(int guiTick, class_1657 player) {
            if (guiTick != this.lastGuiTick) {
                this.query(player);
                this.lastGuiTick = guiTick;
            }
            return this.result;
        }
    }
}

