/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingHandler;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.FallingTreeUtils;
import fr.rakambda.fallingtree.forge.client.event.PlayerLeaveListener;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ComponentWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.forge.event.BlockBreakListener;
import fr.rakambda.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import fr.rakambda.fallingtree.forge.event.LeafBreakingListener;
import fr.rakambda.fallingtree.forge.event.ServerCommandRegistrationListener;
import fr.rakambda.fallingtree.forge.network.ForgePacketHandler;
import fr.rakambda.fallingtree.forge.network.PlayerJoinListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<Direction> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);
    private final ForgePacketHandler packetHandler = new ForgePacketHandler(this);
    private final TagKey<Enchantment> chopperEnchantmentTag = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_all"));
    private final Map<BreakMode, TagKey<Enchantment>> breakModeChopperEnchantmentTag = new HashMap<BreakMode, TagKey<Enchantment>>();

    public FallingTreeCommonsImpl() {
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_all_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ITEM, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_fall_item")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.INSTANTANEOUS, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_instantaneous")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.SHIFT_DOWN, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)FallingTreeUtils.id("chopper_shift_down")));
    }

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        Object[] vars = Arrays.stream(objects).map(o -> {
            if (o instanceof IComponent) {
                IComponent component = (IComponent)o;
                return component.getRaw();
            }
            return o;
        }).toArray();
        return new ComponentWrapper(Component.translatable((String)key, (Object[])vars));
    }

    @Override
    @NotNull
    public ServerPacketHandler getServerPacketHandler() {
        return this.packetHandler;
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent(ForgeRegistries.BLOCKS, tag).map(BlockWrapper::new);
            }
            return this.getRegistryElement(ForgeRegistries.BLOCKS, resourceLocation).stream().map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent(ForgeRegistries.ITEMS, tag).map(ItemWrapper::new);
            }
            return this.getRegistryElement(ForgeRegistries.ITEMS, resourceLocation).stream().map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.registryTagContains(ForgeRegistries.BLOCKS, BlockTags.LEAVES, (Block)block.getRaw()) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent(ForgeRegistries.BLOCKS, BlockTags.LOGS).filter(block -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey(block)).map(ResourceLocation::getPath).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull Direction dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public Direction asDirection(@NotNull DirectionCompat dir) {
        return Direction.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return this.registryTagContains(ForgeRegistries.BLOCKS, BlockTags.WART_BLOCKS, (Block)block.getRaw()) || Blocks.SHROOMLIGHT.equals(block.getRaw());
    }

    @Override
    public boolean isMangroveRoots(@NotNull IBlock block) {
        return Blocks.MANGROVE_ROOTS.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent((Level)level.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), (Player)player.getRaw()));
    }

    @Override
    @NotNull
    public IItemStack getEmptyItemStack() {
        return new ItemStackWrapper(ItemStack.EMPTY);
    }

    @NotNull
    private <T> Optional<T> getRegistryElement(IForgeRegistry<T> registryKey, ResourceLocation identifier) {
        return registryKey.getHolder(identifier).map(Holder::value);
    }

    @NotNull
    private <T> Stream<T> getRegistryTagContent(@NotNull IForgeRegistry<T> registry, @NotNull TagKey<T> tag) {
        return registry.tags().getTag(tag).stream();
    }

    private <T> boolean registryTagContains(@NotNull IForgeRegistry<T> registry, @NotNull TagKey<T> tag, @NotNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void registerForge(@NotNull IEventBus eventBus) {
        this.getServerPacketHandler().registerServer();
        eventBus.register((Object)new BlockBreakListener(this));
        eventBus.register((Object)new LeafBreakingListener(this));
        eventBus.register((Object)new PlayerJoinListener(this));
        eventBus.register((Object)new PlayerLeaveListener(this));
        eventBus.register((Object)new ServerCommandRegistrationListener(this));
    }

    @Override
    @Generated
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Generated
    public TagKey<Enchantment> getChopperEnchantmentTag() {
        return this.chopperEnchantmentTag;
    }

    @Generated
    public Map<BreakMode, TagKey<Enchantment>> getBreakModeChopperEnchantmentTag() {
        return this.breakModeChopperEnchantmentTag;
    }
}

