/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import com.mojang.serialization.DynamicOps;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.component.DrawerSlotComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.StorageCategory;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class DrawerSlot
extends SnapshotParticipant<Snapshot>
implements SingleSlotStorage<ItemVariant>,
DrawerStorage {
    private final DrawerBlockEntity owner;
    private final DrawerStorage.Settings settings;
    private final double capacityMultiplier;
    private ItemVariant item = ItemVariant.blank();
    private long amount;

    public DrawerSlot(DrawerBlockEntity owner, double capacityMultiplier) {
        this.owner = owner;
        this.capacityMultiplier = capacityMultiplier;
        this.settings = new DrawerStorage.Settings();
    }

    @Override
    public DrawerBlockEntity getOwner() {
        return this.owner;
    }

    public void readComponent(DrawerSlotComponent component) {
        this.settings.upgrade = component.upgrade();
        this.settings.limiter = component.limiter();
        this.settings.locked = component.locked();
        this.settings.hidden = component.hidden();
        this.settings.voiding = component.voiding();
        this.settings.duping = component.duping();
        this.item = component.item();
        this.amount = component.amount();
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
    }

    public DrawerSlotComponent toComponent() {
        return new DrawerSlotComponent(this.settings.upgrade, this.settings.limiter, this.settings.locked, this.settings.hidden, this.settings.voiding, this.settings.duping, this.item, this.amount);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals((Object)this.item) && !this.item.isBlank()) {
            return 0L;
        }
        if (!((ConfigData)ExtendedDrawers.CONFIG.get()).misc().allowRecursion() && !resource.getItem().method_31568()) {
            return 0L;
        }
        if (this.item.isBlank() && this.settings.locked && !this.settings.lockOverridden) {
            return 0L;
        }
        long inserted = Math.min(this.getCapacity() - this.amount, maxAmount);
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            if (this.item.isBlank()) {
                this.item = resource;
                this.settings.sortingDirty = true;
            }
        } else if (inserted < 0L) {
            ExtendedDrawers.LOGGER.warn("Somehow inserted negative amount of items ({}) into drawer, aborting. Arguments: item={} maxAmount={}. Status: item={} capacity={} amount={}", new Object[]{inserted, this.item, maxAmount, this.item, this.getCapacity(), this.amount});
            return 0L;
        }
        return this.settings.voiding ? maxAmount : inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!resource.equals((Object)this.item)) {
            return 0L;
        }
        long extracted = Math.min(this.amount, maxAmount);
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            if (this.amount == 0L && !this.settings.locked && !this.settings.duping) {
                this.item = ItemVariant.blank();
                this.settings.sortingDirty = true;
            }
        } else if (extracted < 0L) {
            ExtendedDrawers.LOGGER.warn("Somehow extract negative amount of items ({}) from drawer, aborting. Arguments: item={} maxAmount={}. Status: item={} capacity={} amount={}", new Object[]{extracted, this.item, maxAmount, this.item, this.getCapacity(), this.amount});
            return 0L;
        }
        return this.settings.duping ? maxAmount : extracted;
    }

    public boolean isResourceBlank() {
        return this.item.isBlank();
    }

    public ItemVariant getResource() {
        return this.item;
    }

    @Override
    public long getTrueAmount() {
        return this.amount;
    }

    public long getAmount() {
        return this.settings.duping ? Long.MAX_VALUE : this.amount;
    }

    @Override
    public long getCapacity() {
        StorageCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).storage();
        long capacity = (long)((double)config.drawerCapacity() * this.capacityMultiplier);
        if (config.stackSizeAffectsCapacity()) {
            capacity /= (long)(64.0 / (double)this.item.getItem().method_7882());
        }
        if (this.getUpgrade() != null) {
            capacity = this.getUpgrade().modifier.applyAsLong(capacity);
        }
        capacity = Math.min(capacity, this.getLimiter());
        return capacity;
    }

    protected Snapshot createSnapshot() {
        return new Snapshot((ResourceAmount<ItemVariant>)new ResourceAmount((Object)this.item, this.amount), this.settings.sortingDirty);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = (ItemVariant)snapshot.contents.resource();
        this.amount = snapshot.contents.amount();
        this.settings.sortingDirty = snapshot.itemChanged;
    }

    protected void onFinalCommit() {
        this.update();
    }

    @Override
    public void dumpExcess(class_1937 world, class_2338 pos, @Nullable class_2350 side, @Nullable class_1657 player) {
        if (this.amount > this.getCapacity()) {
            ItemUtils.offerOrDropStacks(world, pos, side, player, this.item, this.amount - this.getCapacity());
            this.amount = this.getCapacity();
        }
        this.update();
    }

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DrawerStorage.super.readNbt(nbt, registryLookup);
        this.item = (ItemVariant)ItemVariant.CODEC.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)nbt.method_10562("item")).getOrThrow();
        this.amount = nbt.method_10537("amount");
        if (this.item.isBlank()) {
            this.amount = 0L;
        }
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DrawerStorage.super.writeNbt(nbt, registryLookup);
        nbt.method_10566("item", (class_2520)ItemVariant.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.item).getOrThrow());
        nbt.method_10544("amount", this.amount);
    }

    @Override
    public void setLocked(boolean locked) {
        if (!locked && this.amount == 0L) {
            this.item = ItemVariant.blank();
        }
        DrawerStorage.super.setLocked(locked);
    }

    @Override
    public DrawerStorage.Settings settings() {
        return this.settings;
    }

    @Override
    public boolean isBlank() {
        return this.isResourceBlank();
    }

    protected record Snapshot(ResourceAmount<ItemVariant> contents, boolean itemChanged) {
    }
}

