/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2291;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class CompressionOverrideLoader
extends class_4309 {
    private static final Gson GSON = new Gson();
    private final CompressionRecipeManager compressionRecipeManager;

    public CompressionOverrideLoader(CompressionRecipeManager compressionRecipeManager) {
        super(GSON, "extended_drawers/compression_overrides");
        this.compressionRecipeManager = compressionRecipeManager;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ArrayList<CompressionLadder> overrides = new ArrayList<CompressionLadder>();
        for (Map.Entry<class_2960, JsonElement> overrideEntry : prepared.entrySet()) {
            class_2960 id = overrideEntry.getKey();
            JsonElement json = overrideEntry.getValue();
            try {
                JsonObject values = class_3518.method_15295((JsonElement)json, (String)"compression override");
                LinkedHashMap<ItemVariant, Integer> steps = new LinkedHashMap<ItemVariant, Integer>();
                int currentCompression = 0;
                for (Map.Entry stepEntry : values.asMap().entrySet()) {
                    ItemVariant item = this.parseItem((String)stepEntry.getKey());
                    int compressionAmount = class_3518.method_15257((JsonElement)((JsonElement)stepEntry.getValue()), (String)("compression amount for " + (String)stepEntry.getKey()));
                    if (compressionAmount == 0) {
                        throw new JsonParseException("Illegal compression amount for " + (String)stepEntry.getKey() + ": 0");
                    }
                    if (compressionAmount < currentCompression) {
                        throw new JsonParseException("Illegal compression amount for %s: %d, amounts should always rise or stay equal".formatted(stepEntry.getKey(), compressionAmount));
                    }
                    currentCompression = compressionAmount;
                    steps.put(item, compressionAmount);
                }
                if (steps.isEmpty()) continue;
                overrides.add(new CompressionLadder(steps.entrySet().stream().map(entry -> new CompressionLadder.Step((ItemVariant)entry.getKey(), (Integer)entry.getValue())).toList()));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                ExtendedDrawers.LOGGER.error("Parsing error loading compression override {}", (Object)id, (Object)e);
            }
        }
        this.compressionRecipeManager.setOverrides(overrides);
    }

    private ItemVariant parseItem(String data) {
        try {
            StringReader reader = new StringReader(data);
            class_2291.class_7215 result = new class_2291((class_7225.class_7874)class_5455.method_40302((class_2378)class_7923.field_41167)).method_9789(reader);
            if (reader.getRemainingLength() != 0) {
                throw new JsonParseException("Failed to parse item, found trailing data: '%s'".formatted(reader.getRemaining()));
            }
            class_1799 stack = new class_1799(result.comp_628());
            stack.method_59692(result.comp_2439());
            return ItemVariant.of((class_1799)stack);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Failed to parse item", (Throwable)e);
        }
    }
}

