/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CompactingDrawerBlockEntityRenderer
extends AbstractDrawerBlockEntityRenderer<CompactingDrawerBlockEntity> {
    public CompactingDrawerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context.method_43335(), context.method_32143());
    }

    public int method_33893() {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        return Math.max(config.iconRenderDistance(), Math.max(config.textRenderDistance(), config.itemRenderDistance()));
    }

    public void render(CompactingDrawerBlockEntity drawer, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2338 drawerPos = drawer.method_11016();
        class_2350 horizontalDir = (class_2350)drawer.method_11010().method_11654((class_2769)StorageDrawerBlock.FACING);
        class_2738 face = (class_2738)drawer.method_11010().method_11654(StorageDrawerBlock.FACE);
        class_2350 dir = StorageDrawerBlock.getFront(drawer.method_11010());
        class_1937 world = drawer.method_10997();
        if (!this.shouldRender(drawer, dir)) {
            return;
        }
        matrices.method_22903();
        this.alignMatrices(matrices, horizontalDir, face);
        light = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(drawer.method_10997())), (class_2338)drawer.method_11016().method_10093(dir));
        if (drawer.storage.isHidden()) {
            this.renderHiddenOverlay(false, light, overlay, matrices, vertexConsumers);
            matrices.method_22909();
            return;
        }
        this.renderIcons(drawer, matrices, vertexConsumers, light, overlay);
        CompactingDrawerStorage.Slot[] slots = drawer.storage.getActiveSlotArray();
        if (slots.length >= 1) {
            matrices.method_22904(0.0, 0.25, 0.0);
            this.renderSlot(ModBlocks.COMPACTING_DRAWER.getSlot(drawer, ModBlocks.COMPACTING_DRAWER.getSlotIndex(drawer, new class_241(0.5f, 0.25f))), light, overlay, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos, world);
        }
        if (slots.length >= 2) {
            matrices.method_22904(0.25, -0.5, 0.0);
            this.renderSlot(ModBlocks.COMPACTING_DRAWER.getSlot(drawer, ModBlocks.COMPACTING_DRAWER.getSlotIndex(drawer, new class_241(0.75f, 0.75f))), light, overlay, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos, world);
        }
        if (slots.length >= 3) {
            matrices.method_22904(-0.5, 0.0, 0.0);
            this.renderSlot(ModBlocks.COMPACTING_DRAWER.getSlot(drawer, ModBlocks.COMPACTING_DRAWER.getSlotIndex(drawer, new class_241(0.25f, 0.75f))), light, overlay, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), drawerPos, world);
        }
        matrices.method_22909();
    }

    private void renderIcons(CompactingDrawerBlockEntity drawer, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_746 player;
        class_243 playerPos;
        ArrayList<class_1058> icons = new ArrayList<class_1058>();
        ClientCategory.IconGroup config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().icons();
        Function blockAtlas = class_310.method_1551().method_1549(class_1723.field_21668);
        if (drawer.storage.isLocked()) {
            icons.add((class_1058)blockAtlas.apply(config.lockedIcon()));
        }
        if (drawer.storage.isVoiding()) {
            icons.add((class_1058)blockAtlas.apply(config.voidingIcon()));
        }
        if (drawer.storage.isHidden()) {
            icons.add((class_1058)blockAtlas.apply(config.hiddenIcon()));
        }
        if (drawer.storage.isDuping()) {
            icons.add((class_1058)blockAtlas.apply(config.dupingIcon()));
        }
        if (drawer.storage.getUpgrade() != null) {
            icons.add((class_1058)blockAtlas.apply(drawer.storage.getUpgrade().sprite));
        }
        if (drawer.storage.hasLimiter()) {
            icons.add((class_1058)blockAtlas.apply(ExtendedDrawers.id("item/limiter")));
        }
        class_243 class_2432 = playerPos = (player = class_310.method_1551().field_1724) == null ? class_243.method_24953((class_2382)drawer.method_11016()) : player.method_19538();
        if (drawer.method_11016().method_19769((class_2374)playerPos, (double)((ConfigData)ExtendedDrawers.CONFIG.get()).client().iconRenderDistance())) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.25, 0.0);
            this.renderIcons(icons, true, light, overlay, matrices, vertexConsumers);
            matrices.method_22909();
        }
    }

    private void renderSlot(CompactingDrawerStorage.Slot slot, int light, int overlay, class_4587 matrices, class_4597 vertexConsumers, int seed, class_2338 pos, class_1937 world) {
        if (slot.isBlocked()) {
            return;
        }
        @Nullable String amount = String.valueOf(slot.getAmount());
        if (slot.getAmount() == 0L && !((ConfigData)ExtendedDrawers.CONFIG.get()).client().displayEmptyCount()) {
            amount = null;
        }
        if (slot.getStorage().isDuping()) {
            amount = "\u221e";
        }
        ItemVariant item = slot.getStorage().isHidden() ? ItemVariant.blank() : slot.getResource();
        this.renderSlot(item, amount, true, false, List.of(), matrices, vertexConsumers, light, overlay, seed, pos, world);
    }
}

