/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import io.github.mattidragon.extendeddrawers.block.base.CreativeBreakBlocker;
import io.github.mattidragon.extendeddrawers.block.base.DrawerInteractionHandler;
import io.github.mattidragon.extendeddrawers.block.base.NetworkBlockWithEntity;
import io.github.mattidragon.extendeddrawers.block.entity.ShadowDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.misc.DrawerInteractionStatusManager;
import io.github.mattidragon.extendeddrawers.misc.DrawerRaycastUtil;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.ShadowDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ShadowDrawerBlock
extends NetworkBlockWithEntity<ShadowDrawerBlockEntity>
implements CreativeBreakBlocker,
DrawerInteractionHandler {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2738> FACE = class_2741.field_12555;

    public ShadowDrawerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(FACE, (Comparable)class_2738.field_12471));
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        ShadowDrawerBlockEntity drawer = (ShadowDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return;
        }
        drawer.recalculateContents();
    }

    private static Storage<ItemVariant> createStorage(class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ShadowDrawerBlockEntity)) {
            throw new IllegalStateException();
        }
        ShadowDrawerBlockEntity shadowDrawer = (ShadowDrawerBlockEntity)class_25862;
        ShadowDrawerBlockEntity shadowDrawerBlockEntity = shadowDrawer;
        Objects.requireNonNull(shadowDrawerBlockEntity);
        return new ShadowDrawerBlockEntity.ShadowDrawerStorage(shadowDrawerBlockEntity, (Storage<ItemVariant>)NetworkStorageCache.get(world, pos));
    }

    @Override
    protected class_2591<ShadowDrawerBlockEntity> getType() {
        return ModBlocks.SHADOW_DRAWER_BLOCK_ENTITY;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, FACE});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2738 face = switch (ctx.method_7715().method_10153()) {
            case class_2350.field_11033 -> class_2738.field_12473;
            case class_2350.field_11036 -> class_2738.field_12475;
            default -> class_2738.field_12471;
        };
        return (class_2680)((class_2680)this.method_9564().method_11657(FACE, (Comparable)face)).method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!this.isFront(state, hit.method_17780()) || !player.method_7294()) {
            return class_1269.field_5811;
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_33562;
        }
        class_3218 serverWorld = (class_3218)world;
        ShadowDrawerBlockEntity drawer = (ShadowDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return class_1269.field_5811;
        }
        class_1799 playerStack = player.method_6047();
        if (player.method_5715() || drawer.item.isBlank()) {
            drawer.item = ItemVariant.of((class_1799)playerStack);
            drawer.method_5431();
            drawer.recalculateContents();
            return class_1269.field_5812;
        }
        boolean isDoubleClick = DrawerInteractionStatusManager.getAndResetInsertStatus(player, pos, 0);
        try (Transaction t = Transaction.openOuter();){
            int inserted;
            Storage<ItemVariant> storage = ShadowDrawerBlock.createStorage(serverWorld, pos);
            if (isDoubleClick) {
                if (drawer.item.isBlank()) {
                    class_1269 class_12692 = class_1269.field_5811;
                    return class_12692;
                }
                inserted = (int)StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), storage, itemVariant -> true, (long)Long.MAX_VALUE, (TransactionContext)t);
            } else {
                if (playerStack.method_7960()) {
                    class_1269 class_12693 = class_1269.field_5811;
                    return class_12693;
                }
                inserted = (int)storage.insert((Object)ItemVariant.of((class_1799)playerStack), (long)playerStack.method_7947(), (TransactionContext)t);
                playerStack.method_7934(inserted);
            }
            if (inserted == 0) {
                class_1269 class_12694 = class_1269.field_33562;
                return class_12694;
            }
            t.commit();
            class_1269 class_12695 = class_1269.field_5812;
            return class_12695;
        }
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        ShadowDrawerBlockEntity drawer = (ShadowDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return;
        }
        class_3965 hit = DrawerRaycastUtil.getTarget(player, pos);
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_241 internalPos = DrawerRaycastUtil.calculateFaceLocation(pos, hit.method_17784(), hit.method_17780(), (class_2350)state.method_11654((class_2769)FACING), (class_2738)state.method_11654(FACE));
        if (internalPos == null) {
            return;
        }
        Storage<ItemVariant> storage = ShadowDrawerBlock.createStorage(serverWorld, pos);
        try (Transaction t = Transaction.openOuter();){
            int extracted = (int)storage.extract((Object)drawer.item, player.method_5715() ? (long)drawer.item.getItem().method_7882() : 1L, (TransactionContext)t);
            if (extracted == 0) {
                return;
            }
            player.method_31548().method_7398(drawer.item.toStack(extracted));
            t.commit();
        }
    }

    @Override
    public boolean isFront(class_2680 state, class_2350 direction) {
        return switch ((class_2738)state.method_11654(FACE)) {
            default -> throw new MatchException(null, null);
            case class_2738.field_12475 -> {
                if (direction == class_2350.field_11036) {
                    yield true;
                }
                yield false;
            }
            case class_2738.field_12473 -> {
                if (direction == class_2350.field_11033) {
                    yield true;
                }
                yield false;
            }
            case class_2738.field_12471 -> direction == state.method_11654((class_2769)FACING);
        };
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return ShadowDrawerBlockNode.INSTANCE;
    }

    @Override
    public class_1269 toggleHide(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        if (side != state.method_11654((class_2769)FACING)) {
            return class_1269.field_5811;
        }
        ShadowDrawerBlockEntity drawer = (ShadowDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return class_1269.field_5811;
        }
        drawer.setHidden(!drawer.isHidden());
        return class_1269.field_5812;
    }
}

