/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.component.DrawerSlotComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.network.node.CompactingDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5250;

public class CompactingDrawerBlock
extends StorageDrawerBlock<CompactingDrawerBlockEntity> {
    public CompactingDrawerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        DrawerSlotComponent component = (DrawerSlotComponent)stack.method_57824(ModDataComponents.COMPACTING_DRAWER_CONTENTS);
        if (component == null) {
            return;
        }
        if (ExtendedDrawers.SHIFT_ACCESS.isShiftPressed()) {
            class_1792 class_17922 = component.upgrade().getItem();
            if (class_17922 instanceof UpgradeItem) {
                UpgradeItem upgrade = (UpgradeItem)class_17922;
                tooltip.add((class_2561)upgrade.method_7848().method_27661().method_27692(class_124.field_1075));
            }
            class_5250 modifierText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"V").method_27692(component.voiding() ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"L").method_27692(component.locked() ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"H").method_27692(component.hidden() ? class_124.field_1068 : class_124.field_1063));
            if (component.duping()) {
                modifierText.method_10852((class_2561)class_2561.method_43470((String)"D").method_27692(class_124.field_1068));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.extended_drawers.modifiers", (Object[])new Object[]{modifierText}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.shift_for_modifiers").method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.drawer_contents").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(component.amount()))).method_27693(" ").method_10852(component.item().toStack().method_7964()).method_27692(class_124.field_1080));
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        CompactingDrawerBlockEntity drawer;
        if (!state.method_27852(newState.method_26204()) && (drawer = (CompactingDrawerBlockEntity)((Object)this.getBlockEntity(world, pos))) != null && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().drawersDropContentsOnBreak()) {
            CompactingDrawerStorage.Slot[] slots = drawer.storage.getSlotArray();
            long amount = drawer.storage.getTrueAmount();
            for (int i = slots.length - 1; i >= 0; --i) {
                CompactingDrawerStorage.Slot slot = slots[i];
                if (slot.isBlocked()) continue;
                long toDrop = amount / slot.getCompression();
                ItemUtils.offerOrDropStacks(world, pos, null, null, slot.getResource(), toDrop);
                amount -= toDrop * slot.getCompression();
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    protected class_2591<CompactingDrawerBlockEntity> getType() {
        return ModBlocks.COMPACTING_DRAWER_BLOCK_ENTITY;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        CompactingDrawerBlockEntity drawer = (CompactingDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return 0;
        }
        return StorageUtil.calculateComparatorOutput((Storage)drawer.storage);
    }

    @Override
    protected ModifierAccess getModifierAccess(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        return drawer.storage;
    }

    @Override
    public int getSlotIndex(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        int slotCount = drawer.storage.getActiveSlotCount();
        int topSlot = switch (slotCount) {
            case 1 -> 0;
            case 2 -> 0;
            case 3 -> 1;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int leftSlot = switch (slotCount) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 0;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int rightSlot = switch (slotCount) {
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 2;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        if (facePos.field_1342 < 0.5f) {
            return topSlot;
        }
        if (facePos.field_1343 < 0.5f) {
            return leftSlot;
        }
        return rightSlot;
    }

    public CompactingDrawerStorage.Slot getSlot(CompactingDrawerBlockEntity drawer, int slot) {
        return drawer.storage.getSlot(slot);
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return CompactingDrawerBlockNode.INSTANCE;
    }
}

