/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.RenderedBufferAccessor;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_1058;
import net.minecraft.class_1767;
import net.minecraft.class_2215;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2546;
import net.minecraft.class_2573;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_9307;
import net.minecraft.class_9801;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.system.MemoryUtil;

public class BannerConstraint
implements VerletConstraint {
    private ModelCube[] partsToCheck;
    private class_2573 bannerBlock;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4d invTransformation = new Matrix4d();
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private Vector2f[] tmpUV;
    private Matrix4f[] textureMatrices;
    private class_9307 patterns;
    private class_1767 baseColor;
    private class_291 vertexBuffer;

    public BannerConstraint(VerletSimulation simulation, class_2573 bannerBlock, class_630 pole, class_630 bar, float tickDelta) {
        int i;
        this.bannerBlock = bannerBlock;
        this.patterns = new class_9307(bannerBlock.method_58122().comp_2428());
        this.baseColor = bannerBlock.method_10908();
        List<VerletConstraint> constraints = simulation.getConstraints();
        for (int i2 = 0; i2 < constraints.size(); ++i2) {
            if (!(constraints.get(i2) instanceof RenderConstraint)) continue;
            constraints.remove(i2--);
        }
        this.partsToCheck = bannerBlock.method_11010().method_26204() instanceof class_2215 ? new ModelCube[]{new ModelCube(pole), new ModelCube(bar)} : new ModelCube[]{new ModelCube(bar)};
        this.calculateTransformation(simulation, tickDelta);
        int capeXPoints = 9;
        int capeYPoints = 17;
        double distance = 0.15000000001500002;
        VerletPoint[][] points = new VerletPoint[capeXPoints][capeYPoints];
        float uvXOff = 0.015625f;
        float uvYOff = 0.015625f;
        float uvXMod = 0.3125f;
        float uvYMod = 0.625f;
        for (int y = 0; y < points[0].length; ++y) {
            for (int x = 0; x < points.length; ++x) {
                Vector3d position = new Vector3d((double)x * distance - (double)capeXPoints * 0.5 * distance + distance * 0.5, (double)y * distance, -0.08928571428571429);
                this.transformation.transformPosition(position);
                VerletPoint point = new VerletPoint(position);
                point.uv.set((float)x / (float)(points.length - 1) * uvXMod + uvXOff, (float)y / (float)(points[0].length - 1) * uvYMod + uvYOff);
                if (y == 0) {
                    point.locked = true;
                }
                points[x][y] = point;
                simulation.addPoint(points[x][y]);
            }
        }
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[0].length; ++y) {
                if (x < points.length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x + 1][y]));
                }
                if (y < points[0].length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x][y + 1]));
                }
                if (x >= points.length - 1 || y >= points[0].length - 1) continue;
                simulation.addQuad(new VerletQuad(points[x][y + 1], points[x + 1][y + 1], points[x + 1][y], points[x][y]));
                simulation.addStick(new VerletStick(points[x][y], points[x + 1][y + 1]));
                simulation.addStick(new VerletStick(points[x + 1][y], points[x][y + 1]));
            }
        }
        simulation.calculateNormals();
        simulation.downloadData();
        this.calculateTransformation(simulation, tickDelta);
        List<VerletQuad> quads = simulation.getQuads();
        int drawCalls = java.lang.Math.min(17, this.patterns.comp_2428().size() + 1);
        int size = quads.size();
        this.tmpUV = new Vector2f[drawCalls * size * 4];
        this.textureMatrices = new Matrix4f[drawCalls];
        for (i = 0; i < this.tmpUV.length; ++i) {
            this.tmpUV[i] = new Vector2f();
        }
        for (i = 0; i < 17 && i < this.patterns.comp_2428().size() + 1; ++i) {
            class_4730 bannerMaterial = null;
            if (i == 0) {
                bannerMaterial = class_4722.field_49769;
            } else {
                class_9307.class_9308 layer = (class_9307.class_9308)this.patterns.comp_2428().get(i - 1);
                bannerMaterial = class_4722.method_33081((class_6880)layer.comp_2429());
            }
            if (bannerMaterial == null) {
                this.textureMatrices[i] = new Matrix4f();
                continue;
            }
            class_1058 sprite = bannerMaterial.method_24148();
            float minU = sprite.method_4594();
            float maxU = sprite.method_4577();
            float minV = sprite.method_4593();
            float maxV = sprite.method_4575();
            float xScale = maxU - minU;
            float yScale = maxV - minV;
            this.textureMatrices[i] = new Matrix4f().translate(minU, minV, 0.0f).scale(xScale, yScale, 0.0f);
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                this.remap(quad.point1.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4]);
                this.remap(quad.point2.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 1]);
                this.remap(quad.point3.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 2]);
                this.remap(quad.point4.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 3]);
            }
        }
    }

    private void calculateTransformation(VerletSimulation simulation, float tickDelta) {
        class_2680 blockState = this.bannerBlock.method_11010();
        class_2338 blockPos = this.bannerBlock.method_11016();
        Vector3d offset = simulation.getOffset();
        Matrix4d test = new Matrix4d();
        if (offset != null) {
            test.translate((double)blockPos.method_10263() - offset.x, (double)blockPos.method_10264() - offset.y, (double)blockPos.method_10260() - offset.z);
        } else {
            test.translate((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        }
        if (blockState.method_26204() instanceof class_2215) {
            test.translate(0.5, 0.5, 0.5);
            blockRotation = (float)(-((Integer)blockState.method_11654((class_2769)class_2215.field_9924)).intValue() * 360) / 16.0f;
            test.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(blockRotation));
        } else {
            test.translate(0.5, -0.1666666716337204, 0.5);
            blockRotation = -((class_2350)blockState.method_11654((class_2769)class_2546.field_11722)).method_10144();
            test.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(blockRotation));
            test.translate(0.0, -0.3125, -0.4375);
        }
        test.scale(0.6666667, -0.6666667, -0.6666667);
        if (simulation.getOffset() == null) {
            long gameTime = this.bannerBlock.method_10997().method_8510();
            float n = ((float)java.lang.Math.floorMod((long)(blockPos.method_10263() * 7 + blockPos.method_10264() * 9 + blockPos.method_10260() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
            float xRot = (-0.0125f + 0.01f * class_3532.method_15362((float)((float)java.lang.Math.PI * 2 * n))) * (float)java.lang.Math.PI;
            double yPos = -32.0;
            test.translate(0.0, yPos / 16.0, 0.0);
            if (xRot != 0.0f) {
                test.rotate((Quaternionfc)class_7833.field_40714.rotation(xRot));
            }
        }
        this.transformation.set((Matrix4dc)test);
        this.transformation.invert(this.invTransformation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        for (int i = 0; i < this.partsToCheck.length; ++i) {
            this.partsToCheck[i].pose = this.partsToCheck[i].part.method_32084();
            this.partsToCheck[i].updateHitbox();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
        float enlarge = 0.075f;
        for (int i = 0; i < this.partsToCheck.length; ++i) {
            ModelCube part = this.partsToCheck[i];
            float minX = part.minX - enlarge;
            float minY = part.minY - enlarge;
            float minZ = part.minZ - enlarge;
            float maxX = part.maxX + enlarge;
            float maxY = part.maxY + enlarge;
            float maxZ = part.maxZ + enlarge;
            for (VerletPoint point : simulation.getPoints()) {
                if (point.locked) continue;
                this.invTransformation.transformPosition(this.invPoint.set((Vector3dc)point.position));
                if (!this.helper.movePointOutOfBox(this.invPoint, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                point.position.set((Vector3dc)this.transformation.transformPosition(this.invPoint));
                point.friction = 0.6;
            }
        }
    }

    public void translateAndRotate(class_4587 poseStack, class_5603 pose) {
        poseStack.method_22904((double)pose.field_27702 / 16.0, (double)pose.field_27703 / 16.0, (double)pose.field_27704 / 16.0);
        if (pose.field_27707 != 0.0f) {
            poseStack.method_22907(class_7833.field_40718.rotation(pose.field_27707));
        }
        if (pose.field_27706 != 0.0f) {
            poseStack.method_22907(class_7833.field_40716.rotation(pose.field_27706));
        }
        if (pose.field_27705 != 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotation(pose.field_27705));
        }
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double renderPercent, VerletSimulation simulation) {
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        int size = quads.size();
        Matrix4f oldTextureMatrix = RenderSystem.getTextureMatrix();
        float[] color = new float[4];
        if (simulation.getQuads().size() > 0) {
            List<VerletPoint> points = simulation.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                points.get(i).updateRenderPosition(renderPercent);
            }
            class_9801 bufferedRenderer = null;
            for (int i = 0; i < 17 && i < this.patterns.comp_2428().size() + 1; ++i) {
                class_287 bufferbuilder;
                class_4730 bannerMaterial;
                int icolor;
                if (i == 0) {
                    icolor = this.baseColor.method_7787();
                    bannerMaterial = class_4722.field_49769;
                } else {
                    class_9307.class_9308 layer = (class_9307.class_9308)this.patterns.comp_2428().get(i - 1);
                    icolor = layer.comp_2430().method_7787();
                    bannerMaterial = class_4722.method_33081((class_6880)layer.comp_2429());
                }
                color[0] = (float)class_5253.class_5254.method_27765((int)icolor) / 255.0f;
                color[1] = (float)class_5253.class_5254.method_27766((int)icolor) / 255.0f;
                color[2] = (float)class_5253.class_5254.method_27767((int)icolor) / 255.0f;
                color[3] = (float)class_5253.class_5254.method_27762((int)icolor) / 255.0f;
                if (bannerMaterial == null) continue;
                class_1058 sprite = bannerMaterial.method_24148();
                if (StarterClient.optifabric) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
                }
                int glID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_4624();
                RenderSystem.setShaderTexture((int)0, (int)glID);
                RenderSystem.bindTexture((int)glID);
                boolean releaseBuffer = i == 16 || i == this.patterns.comp_2428().size() || StarterClient.iris && Iris.isExtending();
                int drawCallIndex = i * size * 4;
                if (bufferedRenderer != null) {
                    if (StarterClient.iris && Iris.isExtending()) {
                        RenderSystem.setTextureMatrix((Matrix4f)this.textureMatrices[i]);
                    } else {
                        ByteBuffer buffer = bufferedRenderer.method_60818();
                        int count = 0;
                        int ccount = 0;
                        int vertexCount = quads.size() * 6;
                        int vertexSize = buffer.capacity() / vertexCount;
                        long pointer = MemoryUtil.memAddress((ByteBuffer)buffer);
                        for (int j = 0; j < quads.size(); ++j) {
                            int multiple = j * 4;
                            int uvIndex = drawCallIndex + multiple;
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 3]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 2]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 1]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 3]);
                            this.updateUV(pointer, vertexSize * count++, this.tmpUV[uvIndex + 1]);
                            if (!StarterClient.optifabric) continue;
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                            this.updateColor(pointer, vertexSize * ccount++, color);
                        }
                    }
                    ((RenderedBufferAccessor)bufferedRenderer.field_52093).setIgnoreRelease(!releaseBuffer);
                    if (bufferedRenderer.field_52094 != null) {
                        ((RenderedBufferAccessor)bufferedRenderer.field_52094).setIgnoreRelease(!releaseBuffer);
                    }
                    this.drawWithShader(bufferedRenderer);
                    continue;
                }
                if (StarterClient.iris && Iris.isExtending()) {
                    bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1580);
                    for (j = 0; j < quads.size(); ++j) {
                        VerletQuad quad = quads.get(j);
                        RenderSystem.setTextureMatrix((Matrix4f)this.textureMatrices[i]);
                        if (ConfigClient.clothSmoothShading) {
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.point1.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.point2.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.point3.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.point4.bufferNormal, brightness, color);
                            continue;
                        }
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, quad.point1.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, quad.point2.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, quad.point3.uv, quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, quad.point4.uv, quad.bufferNormal, brightness, color);
                    }
                } else {
                    bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1580);
                    for (j = 0; j < quads.size(); ++j) {
                        VerletQuad quad = quads.get(j);
                        int multiple = j * 4;
                        int uvIndex = drawCallIndex + multiple;
                        if (ConfigClient.clothSmoothShading) {
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.point3.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                            this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                            continue;
                        }
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point3.renderPosition, this.tmpUV[uvIndex + 2], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point1.renderPosition, this.tmpUV[uvIndex], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point4.renderPosition, this.tmpUV[uvIndex + 3], quad.bufferNormal, brightness, color);
                        this.bufferVertex(bufferbuilder, renderPercent, quad.point2.renderPosition, this.tmpUV[uvIndex + 1], quad.bufferNormal, brightness, color);
                    }
                }
                bufferedRenderer = bufferbuilder.method_60794();
                ((RenderedBufferAccessor)bufferedRenderer.field_52093).setIgnoreRelease(!releaseBuffer);
                if (bufferedRenderer.field_52094 != null) {
                    ((RenderedBufferAccessor)bufferedRenderer.field_52094).setIgnoreRelease(!releaseBuffer);
                }
                this.drawWithShader(bufferedRenderer);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setTextureMatrix((Matrix4f)oldTextureMatrix);
        this.vertexBuffer = null;
    }

    public void drawWithShader(class_9801 renderedBuffer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._drawWithShader(renderedBuffer));
        } else {
            this._drawWithShader(renderedBuffer);
        }
    }

    private void _drawWithShader(class_9801 renderedBuffer) {
        if (StarterClient.iris && Iris.isExtending() && this.vertexBuffer != null) {
            this.vertexBuffer.method_1353();
        } else {
            this.vertexBuffer = renderedBuffer.method_60822().comp_749().method_43446();
            this.vertexBuffer.method_1353();
            this.vertexBuffer.method_1352(renderedBuffer);
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        }
    }

    private void remap(Vector2f uv, float minU, float maxU, float minV, float maxV, Vector2f dst) {
        dst.set(Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV));
    }

    private void bufferVertex(class_287 bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float[] color) {
        if (StarterClient.optifabric) {
            bufferbuilder.method_22912((float)position.x, (float)position.y, (float)position.z).method_22915(color[0], color[1], color[2], 1.0f).method_22913(uv.x, uv.y).method_22922(class_4608.field_21444).method_60803(brightness).method_22914((float)normal.x, (float)normal.y, (float)normal.z);
        } else {
            bufferbuilder.method_22912((float)position.x, (float)position.y, (float)position.z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(uv.x, uv.y).method_22922(class_4608.field_21444).method_60803(brightness).method_22914((float)normal.x, (float)normal.y, (float)normal.z);
        }
    }

    private void updateUV(long pointer, int offset, Vector2f uv) {
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 16L), (float)uv.x);
        MemoryUtil.memPutFloat((long)(pointer + (long)offset + 20L), (float)uv.y);
    }

    private void updateColor(long pointer, int offset, float[] color) {
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 12L), (byte)((byte)(color[0] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 13L), (byte)((byte)(color[1] * 255.0f)));
        MemoryUtil.memPutByte((long)(pointer + (long)offset + 14L), (byte)((byte)(color[2] * 255.0f)));
    }
}

