/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsSubScreen;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class LiquidSettingsScreen
extends LegacyOptionsSubScreen {
    private LegacyOptionsList list;
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.liquidphysics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private final CycleOption<Boolean> PHYSICS_CUDA_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.cudaliquids", gameOptions -> ConfigClient.cudaLiquids, (gameOptions, option, value) -> {
        if (((CycleOption)option).active) {
            ConfigClient.cudaLiquids = value;
            ConfigClient.save();
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
            StarterClient.createPhysicsCooking(ConfigClient.cudaLiquids());
            this.list.method_25396().clear();
            class_310.method_1551().method_1507((class_437)new LiquidSettingsScreen(this.lastScreen, this.options));
        }
    }).setTooltip(minecraft -> graphicsStatus -> {
        if (class_310.method_1551().field_1687 != null || !StarterClient.cudaAvailable) {
            return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.error");
        }
        return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.info");
    });
    private static final ProgressOption PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.cudaliquids.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.cudaLiquidsParticleSize, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsParticleSize = value.floatValue();
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.cudaliquids.size", String.format("%.2f", option.get((class_315)gameOptions))), minecraft -> {
        if (class_310.method_1551().field_1687 != null || !StarterClient.cudaAvailable) {
            return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.size.error");
        }
        return class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.size.info");
    });
    private static final ProgressOption PHYSICS_CUDA_LIQUIDS_BLUR_PASSES = new ProgressOption("physicsmod.menu.liquid.cudaliquids.blur", 1.0, 10.0, 1.0f, gameOptions -> ConfigClient.cudaLiquidsBlurPasses, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsBlurPasses = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.cudaliquids.blur", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.blur.info"));
    private static final ProgressOption PHYSICS_LIQUID_CPU_THREADS = new ProgressOption("physicsmod.menu.liquid.liquidthreads", 1.0, Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.liquidThreads, (gameOptions, value) -> {
        ConfigClient.liquidThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
        if (Liquid.threads != null) {
            for (int i = 0; i < Liquid.threads.length; ++i) {
                Liquid.threads[i].cancel();
            }
        }
        Liquid.threads = null;
        Liquid.initThreads();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidthreads", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.liquidthreads.info"));
    private static final ProgressOption PHYSICS_LIQUID_DENSITY = new ProgressOption("physicsmod.menu.liquid.waterdensity", 3.0, 8.0, 1.0f, gameOptions -> ConfigClient.waterDensity, (gameOptions, value) -> {
        ConfigClient.waterDensity = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.waterdensity", Integer.toString((int)option.get((class_315)gameOptions))), minecraft -> class_2561.method_43471((String)"physicsmod.menu.liquid.waterdensity.info"));
    private static final ProgressOption PHYSICS_LIQUID_SOURCE_DISTANCE = new ProgressOption("physicsmod.menu.liquid.liquidsourcedistance", 1.0, 40.0, 0.1f, gameOptions -> ConfigClient.liquidSourceDistance, (gameOptions, value) -> {
        ConfigClient.liquidSourceDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidsourcedistance", String.format("%.0f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((class_315)gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private List<class_5481> info;

    public LiquidSettingsScreen(class_437 parent, class_315 options) {
        super(parent, options, (class_2561)class_2561.method_43471((String)"physicsmod.menu.liquid.title.pro"));
        this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.liquid.warning"), 300);
    }

    protected void method_25426() {
        this.list = new LegacyOptionsList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        if (!StarterClient.cudaAvailable) {
            this.PHYSICS_CUDA_LIQUIDS.active = false;
            LiquidSettingsScreen.PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE.active = false;
            this.list.renderBackgroundWhenIngame = false;
        } else {
            this.PHYSICS_CUDA_LIQUIDS.active = true;
            LiquidSettingsScreen.PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE.active = true;
        }
        if (ConfigClient.cudaLiquids()) {
            this.list.addBig(this.PHYSICS_CUDA_LIQUIDS);
            this.list.addBig(PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE);
            this.list.addBig(PHYSICS_CUDA_LIQUIDS_BLUR_PASSES);
            this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.liquid.cudaliquids.commands"), 300);
        } else {
            this.list.addSmall(PHYSICS_LIQUIDS, this.PHYSICS_CUDA_LIQUIDS);
            this.list.addSmall(PHYSICS_LIQUID_DENSITY, PHYSICS_LIQUID_CPU_THREADS);
            this.list.addBig(PHYSICS_LIQUID_SOURCE_DISTANCE);
            this.list.addSmall(PHYSICS_LIFETIME_LIQUID, PHYSICS_LIFETIME_VARIANCE_LIQUID);
            this.info = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"physicsmod.menu.liquid.warning"), 300);
        }
        this.field_22786.add(this.list);
        this.method_37063((class_364)ButtonSettings.builder(this.field_22789 / 2 - 50, this.field_22790 - 27, 100, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.lastScreen)));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        int yOffset = 137;
        if (ConfigClient.cudaLiquids()) {
            yOffset = 112;
        }
        int lineY = 0;
        for (class_5481 sequence : this.info) {
            guiGraphics.method_35720(this.field_22793, sequence, (this.field_22789 - 300) / 2, yOffset + lineY, 0xFFFF55);
            lineY += 10;
        }
        BaseRenderer.renderSettingsTooltip(this.list, guiGraphics, mouseX, mouseY, this.field_22789, this.field_22790);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    @Override
    public void method_25419() {
        ConfigClient.save();
        super.method_25419();
    }

    private /* synthetic */ void lambda$init$32(class_4185 button) {
        this.field_22787.method_1507(this.lastScreen);
    }

    private static /* synthetic */ void lambda$init$31(class_4185 button) {
        class_156.method_668().method_670("https://minecraftphysicsmod.com/pro");
    }
}

