/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.snow;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.snow.math.Ray;
import net.diebuddies.physics.snow.math.RayHit;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4184.class})
public class MixinCamera {
    @Shadow
    private class_1922 field_18710;
    @Shadow
    private class_243 field_18712 = class_243.field_1353;
    @Shadow
    @Final
    private Vector3f field_18714;
    @Unique
    private Vector3d rayStartPos = new Vector3d();
    @Unique
    private Vector3d rayDirection = new Vector3d();

    @Inject(at={@At(value="RETURN")}, method={"getMaxZoom"}, cancellable=true)
    private void getMaxZoom(float maxZoom, CallbackInfoReturnable<Double> info) {
        class_1922 class_19222 = this.field_18710;
        if (class_19222 instanceof class_638) {
            class_638 clientLevel = (class_638)class_19222;
            if (ConfigClient.areSnowPhysicsEnabled()) {
                try {
                    SnowWorld snowWorld = PhysicsMod.getInstance((class_1937)clientLevel).getPhysicsWorld().getSnowWorld();
                    double offset = -0.5;
                    this.rayStartPos.set(this.field_18712.field_1352 * (double)IChunk.CHUNK_MULTIPLE + offset, this.field_18712.field_1351 * (double)IChunk.CHUNK_MULTIPLE + offset, this.field_18712.field_1350 * (double)IChunk.CHUNK_MULTIPLE + offset);
                    this.rayDirection.set((double)(-this.field_18714.x()), (double)(-this.field_18714.y()), (double)(-this.field_18714.z()));
                    Ray ray = new Ray(this.rayStartPos, this.rayDirection);
                    RayHit rayHit = snowWorld.contouring.castFastLevelRay(ray, 6.0 * (double)IChunk.CHUNK_MULTIPLE, 0.25 * (double)IChunk.CHUNK_MULTIPLE, 0.01 * (double)IChunk.CHUNK_MULTIPLE, 24 * IChunk.CHUNK_MULTIPLE);
                    if (rayHit != null) {
                        double distanceToHit = rayHit.point.distance((Vector3dc)this.rayStartPos) / (double)IChunk.CHUNK_MULTIPLE;
                        double zoomAdjustment = (double)ConfigClient.snowThickness * 0.5;
                        if (ConfigClient.snowQuality == 0) {
                            zoomAdjustment = (double)ConfigClient.snowThickness * 0.75;
                        }
                        if (ConfigClient.snowType == 1 || !ConfigClient.snowSmoothShading) {
                            zoomAdjustment = 0.0;
                        }
                        info.setReturnValue((Object)Math.min((double)maxZoom, distanceToHit * (0.9 - zoomAdjustment)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

