/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    public final Minecraft mc = Minecraft.getInstance();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading.get();
        switch (lodShading) {
            default: {
                if (this.mc.level != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return this.mc.level.getShade(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return this.mc.hasSingleplayerServer();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return this.mc.getCurrentServer() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public String getCurrentServerName() {
        return this.mc.getCurrentServer().name;
    }

    @Override
    public String getCurrentServerIp() {
        return this.mc.getCurrentServer().ip;
    }

    @Override
    public String getCurrentServerVersion() {
        return this.mc.getCurrentServer().version.getString();
    }

    public LocalPlayer getPlayer() {
        return this.mc.player;
    }

    @Override
    public boolean playerExists() {
        return this.mc.player != null;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.getPlayer().getUUID();
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        BlockPos playerPos = this.getPlayer().blockPosition();
        return new DhBlockPos(playerPos.getX(), playerPos.getY(), playerPos.getZ());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        ChunkPos playerPos = this.getPlayer().chunkPosition();
        return new DhChunkPos(playerPos.x, playerPos.z);
    }

    public ModelManager getModelManager() {
        return this.mc.getModelManager();
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        if (this.mc.level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(this.mc.level);
    }

    @Override
    @Deprecated
    public File getGameDirectory() {
        return this.getInstallationDirectory();
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(this.mc.getProfiler());
        } else if (this.mc.getProfiler() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = this.mc.getProfiler();
        }
        return this.profilerWrapper;
    }

    @Override
    public ArrayList<ILevelWrapper> getAllServerWorlds() {
        ArrayList<ILevelWrapper> worlds = new ArrayList<ILevelWrapper>();
        Iterable serverWorlds = this.mc.getSingleplayerServer().getAllLevels();
        for (ServerLevel world : serverWorlds) {
            worlds.add(ServerLevelWrapper.getWrapper(world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer p = this.getPlayer();
        if (p == null) {
            return;
        }
        p.sendSystemMessage((Component)Component.translatable((String)string));
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.getInstance().delayCrash(report);
    }

    @Override
    public Object getOptionsObject() {
        return this.mc.options;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return this.mc.gameDirectory;
    }

    @Override
    public void executeOnRenderThread(Runnable runnable) {
        this.mc.execute(runnable);
    }
}

