/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.logging.log4j.Logger;

public class ChunkWrapper
implements IChunkWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new BlockPos.MutableBlockPos());
    private final ChunkAccess chunk;
    private final DhChunkPos chunkPos;
    private final LevelReader lightSource;
    private final ILevelWrapper wrappedLevel;
    private boolean isDhLightCorrect = false;
    private boolean isMcClientLightingCorrect = false;
    private ChunkLightStorage blockLightStorage;
    private ChunkLightStorage skyLightStorage;
    private ArrayList<DhBlockPos> blockLightPosList = null;
    private boolean useDhLighting;
    private int minNonEmptyHeight = Integer.MIN_VALUE;
    private int maxNonEmptyHeight = Integer.MAX_VALUE;
    private int blockBiomeHashCode = 0;
    private static final ConcurrentLinkedQueue<ChunkWrapper> chunksNeedingClientLightUpdating = new ConcurrentLinkedQueue();

    public ChunkWrapper(ChunkAccess chunk, LevelReader lightSource, ILevelWrapper wrappedLevel) {
        boolean isDhGeneratedChunk;
        this.chunk = chunk;
        this.lightSource = lightSource;
        this.wrappedLevel = wrappedLevel;
        this.chunkPos = new DhChunkPos(chunk.getPos().x, chunk.getPos().z);
        this.useDhLighting = isDhGeneratedChunk = this.lightSource.getClass() == DhLitWorldGenRegion.class;
        chunksNeedingClientLightUpdating.add(this);
    }

    @Override
    public int getHeight() {
        return ChunkWrapper.getHeight(this.chunk);
    }

    public static int getHeight(ChunkAccess chunk) {
        return chunk.getHeight();
    }

    @Override
    public int getMinBuildHeight() {
        return ChunkWrapper.getMinBuildHeight(this.chunk);
    }

    public static int getMinBuildHeight(ChunkAccess chunk) {
        return chunk.getMinBuildHeight();
    }

    @Override
    public int getMaxBuildHeight() {
        return ChunkWrapper.getMaxBuildHeight(this.chunk);
    }

    public static int getMaxBuildHeight(ChunkAccess chunk) {
        return chunk.getMaxBuildHeight();
    }

    @Override
    public int getMinNonEmptyHeight() {
        if (this.minNonEmptyHeight != Integer.MIN_VALUE) {
            return this.minNonEmptyHeight;
        }
        this.minNonEmptyHeight = this.getMinBuildHeight();
        LevelChunkSection[] sections = this.chunk.getSections();
        for (int index = 0; index < sections.length; ++index) {
            if (sections[index] == null || ChunkWrapper.isChunkSectionEmpty(sections[index])) continue;
            this.minNonEmptyHeight = this.getChunkSectionMinHeight(index);
            break;
        }
        return this.minNonEmptyHeight;
    }

    @Override
    public int getMaxNonEmptyHeight() {
        if (this.maxNonEmptyHeight != Integer.MAX_VALUE) {
            return this.maxNonEmptyHeight;
        }
        this.maxNonEmptyHeight = this.getMaxBuildHeight();
        LevelChunkSection[] sections = this.chunk.getSections();
        for (int index = sections.length - 1; index >= 0; --index) {
            if (sections[index] == null || ChunkWrapper.isChunkSectionEmpty(sections[index])) continue;
            this.maxNonEmptyHeight = this.getChunkSectionMinHeight(index) + 16;
            break;
        }
        return this.maxNonEmptyHeight;
    }

    private static boolean isChunkSectionEmpty(LevelChunkSection section) {
        return section.hasOnlyAir();
    }

    private int getChunkSectionMinHeight(int index) {
        return this.chunk.getSectionYFromSectionIndex(index) * 16;
    }

    @Override
    public int getSolidHeightMapValue(int xRel, int zRel) {
        return this.chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE).getFirstAvailable(xRel, zRel);
    }

    @Override
    public int getLightBlockingHeightMapValue(int xRel, int zRel) {
        return this.chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING).getFirstAvailable(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int relX, int relY, int relZ) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.chunk.getNoiseBiome(QuartPos.fromBlock((int)relX), QuartPos.fromBlock((int)relY), QuartPos.fromBlock((int)relZ)), this.wrappedLevel);
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        BlockPos.MutableBlockPos blockPos = MUTABLE_BLOCK_POS_REF.get();
        blockPos.setX(relX);
        blockPos.setY(relY);
        blockPos.setZ(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.getBlockState((BlockPos)blockPos), this.wrappedLevel);
    }

    @Override
    public DhChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public ChunkAccess getChunk() {
        return this.chunk;
    }

    public ChunkStatus getStatus() {
        return ChunkWrapper.getStatus(this.getChunk());
    }

    public static ChunkStatus getStatus(ChunkAccess chunk) {
        return chunk.getPersistedStatus();
    }

    @Override
    public int getMaxBlockX() {
        return this.chunk.getPos().getMaxBlockX();
    }

    @Override
    public int getMaxBlockZ() {
        return this.chunk.getPos().getMaxBlockZ();
    }

    @Override
    public int getMinBlockX() {
        return this.chunk.getPos().getMinBlockX();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunk.getPos().getMinBlockZ();
    }

    @Override
    public void setIsDhLightCorrect(boolean isDhLightCorrect) {
        this.isDhLightCorrect = isDhLightCorrect;
    }

    @Override
    public void setUseDhLighting(boolean useDhLighting) {
        this.useDhLighting = useDhLighting;
    }

    @Override
    public boolean isLightCorrect() {
        if (this.useDhLighting) {
            return this.isDhLightCorrect;
        }
        if (this.chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)this.chunk;
            if (levelChunk.getLevel() instanceof ClientLevel) {
                return this.isMcClientLightingCorrect;
            }
            return this.chunk.isLightCorrect() && levelChunk.loaded;
        }
        return this.chunk.isLightCorrect();
    }

    @Override
    public int getDhBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getBlockLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhBlockLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getBlockLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getBlockLightStorage() {
        if (this.blockLightStorage == null) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(this);
        }
        return this.blockLightStorage;
    }

    public void setBlockLightStorage(ChunkLightStorage lightStorage) {
        this.blockLightStorage = lightStorage;
    }

    @Override
    public int getDhSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getSkyLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhSkyLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getSkyLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getSkyLightStorage() {
        if (this.skyLightStorage == null) {
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(this);
        }
        return this.skyLightStorage;
    }

    public void setSkyLightStorage(ChunkLightStorage lightStorage) {
        this.skyLightStorage = lightStorage;
    }

    @Override
    public int getBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getBlockLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.getBrightness(LightLayer.BLOCK, new BlockPos(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public int getSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getSkyLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.getBrightness(LightLayer.SKY, new BlockPos(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public synchronized ArrayList<DhBlockPos> getBlockLightPosList() {
        if (this.blockLightPosList == null) {
            this.blockLightPosList = new ArrayList();
            this.chunk.findBlockLightSources((blockPos, blockState) -> this.blockLightPosList.add(new DhBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ())));
        }
        return this.blockLightPosList;
    }

    public static void syncedUpdateClientLightStatus() {
        ChunkWrapper chunkWrapper = chunksNeedingClientLightUpdating.poll();
        while (chunkWrapper != null) {
            chunkWrapper.updateIsClientLightingCorrect();
            chunkWrapper = chunksNeedingClientLightUpdating.poll();
        }
    }

    private void updateIsClientLightingCorrect() {
        if (this.chunk instanceof LevelChunk && ((LevelChunk)this.chunk).getLevel() instanceof ClientLevel) {
            LevelChunk levelChunk = (LevelChunk)this.chunk;
            ClientChunkCache clientChunkCache = ((ClientLevel)levelChunk.getLevel()).getChunkSource();
            this.isMcClientLightingCorrect = clientChunkCache.getChunkForLighting(this.chunk.getPos().x, this.chunk.getPos().z) != null && ChunkWrapper.checkLightSectionsOnChunk(levelChunk, levelChunk.getLevel().getLightEngine());
        }
    }

    private static boolean checkLightSectionsOnChunk(LevelChunk chunk, LevelLightEngine engine) {
        LevelChunkSection[] sections = chunk.getSections();
        int minY = chunk.getMinSection();
        int maxY = chunk.getMaxSection();
        for (int y = minY; y < maxY; ++y) {
            LevelChunkSection section = sections[chunk.getSectionIndexFromSectionY(y)];
            if (section.hasOnlyAir() || engine.lightOnInSection(SectionPos.of((ChunkPos)chunk.getPos(), (int)y))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doNearbyChunksExist() {
        if (this.lightSource instanceof DhLitWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.getChunk(dx + this.chunk.getPos().x, dz + this.chunk.getPos().z, ChunkStatus.BIOMES, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isStillValid() {
        return this.wrappedLevel.tryGetChunk(this.chunkPos) == this;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + String.valueOf(this.chunk.getPos());
    }
}

