/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogColorMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.fog.LodFogConfig;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.awt.Color;
import org.lwjgl.opengl.GL32;

public class FogShader
extends AbstractShaderRenderer {
    public static FogShader INSTANCE = new FogShader(LodFogConfig.generateFogConfig());
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IVersionConstants VERSION_CONSTANTS = SingletonInjector.INSTANCE.get(IVersionConstants.class);
    private final LodFogConfig fogConfig;
    private Mat4f inverseMvmProjMatrix;
    public int gInvertedModelViewProjectionUniform;
    public int gDepthMapUniform;
    public int fogColorUniform;
    public int fogScaleUniform;
    public int fogVerticalScaleUniform;
    public int nearFogStartUniform;
    public int nearFogLengthUniform;
    public int fullFogModeUniform;

    public FogShader(LodFogConfig fogConfig) {
        this.fogConfig = fogConfig;
    }

    @Override
    public void onInit() {
        this.shader = new ShaderProgram(() -> Shader.loadFile("shaders/normal.vert", false, new StringBuilder()).toString(), () -> this.fogConfig.loadAndProcessFragShader("shaders/fog/fog.frag", false).toString(), "fragColor", new String[]{"vPosition"});
        this.gInvertedModelViewProjectionUniform = this.shader.tryGetUniformLocation("gInvMvmProj");
        this.gDepthMapUniform = this.shader.tryGetUniformLocation("gDepthMap");
        this.fogColorUniform = this.shader.tryGetUniformLocation("fogColor");
        this.fullFogModeUniform = this.shader.tryGetUniformLocation("fullFogMode");
        this.fogScaleUniform = this.shader.tryGetUniformLocation("fogScale");
        this.fogVerticalScaleUniform = this.shader.tryGetUniformLocation("fogVerticalScale");
        this.nearFogStartUniform = this.shader.tryGetUniformLocation("nearFogStart");
        this.nearFogLengthUniform = this.shader.tryGetUniformLocation("nearFogLength");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        this.shader.setUniform(this.gInvertedModelViewProjectionUniform, this.inverseMvmProjMatrix);
        int lodDrawDistance = Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16;
        int vanillaDrawDistance = MC_RENDER.getRenderDistance() * 16;
        vanillaDrawDistance += 32;
        if (this.gDepthMapUniform != -1) {
            GL32.glActiveTexture((int)33985);
            GL32.glBindTexture((int)3553, (int)LodRenderer.getActiveDepthTextureId());
            GL32.glUniform1i((int)this.gDepthMapUniform, (int)1);
        }
        if (this.fullFogModeUniform != -1) {
            this.shader.setUniform(this.fullFogModeUniform, MC_RENDER.isFogStateSpecial() ? 1 : 0);
        }
        if (this.fogColorUniform != -1) {
            this.shader.setUniform(this.fogColorUniform, MC_RENDER.isFogStateSpecial() ? this.getSpecialFogColor(partialTicks) : this.getFogColor(partialTicks));
        }
        float nearFogLen = (float)vanillaDrawDistance * 0.2f / (float)lodDrawDistance;
        float nearFogStart = (float)vanillaDrawDistance * (VERSION_CONSTANTS.isVanillaRenderedChunkSquare() ? (float)Math.sqrt(2.0) : 1.0f) / (float)lodDrawDistance;
        if (this.nearFogStartUniform != -1) {
            this.shader.setUniform(this.nearFogStartUniform, nearFogStart);
        }
        if (this.nearFogLengthUniform != -1) {
            this.shader.setUniform(this.nearFogLengthUniform, nearFogLen);
        }
        if (this.fogScaleUniform != -1) {
            this.shader.setUniform(this.fogScaleUniform, 1.0f / (float)lodDrawDistance);
        }
        if (this.fogVerticalScaleUniform != -1) {
            this.shader.setUniform(this.fogVerticalScaleUniform, 1.0f / (float)MC.getWrappedClientLevel().getHeight());
        }
    }

    private Color getFogColor(float partialTicks) {
        Color fogColor = Config.Client.Advanced.Graphics.Fog.colorMode.get() == EDhApiFogColorMode.USE_SKY_COLOR ? MC_RENDER.getSkyColor() : MC_RENDER.getFogColor(partialTicks);
        return fogColor;
    }

    private Color getSpecialFogColor(float partialTicks) {
        return MC_RENDER.getSpecialFogColor(partialTicks);
    }

    public void setModelViewProjectionMatrix(Mat4f combinedModelViewProjectionMatrix) {
        this.inverseMvmProjMatrix = new Mat4f(combinedModelViewProjectionMatrix);
        this.inverseMvmProjMatrix.invert();
    }

    @Override
    protected void onRender() {
        GLState state = new GLState();
        GL32.glDisable((int)2929);
        GL32.glDisable((int)3089);
        GL32.glEnable((int)3042);
        GL32.glBlendEquation((int)32774);
        GL32.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)LodRenderer.getActiveColorTextureId());
        ScreenQuad.INSTANCE.render();
        state.restore();
    }
}

