/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShaderProgram;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePostGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePreGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;

public class LodRenderProgram
extends ShaderProgram
implements IDhApiShaderProgram {
    public static final String VERTEX_SHADER_PATH = "shaders/standard.vert";
    public static final String VERTEX_CURVE_SHADER_PATH = "shaders/curve.vert";
    public static final String FRAGMENT_SHADER_PATH = "shaders/flat_shaded.frag";
    public final AbstractVertexAttribute vao;
    public final int combinedMatUniform = this.getUniformLocation("combinedMatrix");
    public final int modelOffsetUniform = this.getUniformLocation("modelOffset");
    public final int worldYOffsetUniform = this.tryGetUniformLocation("worldYOffset");
    public final int mircoOffsetUniform = this.getUniformLocation("mircoOffset");
    public final int earthRadiusUniform = this.tryGetUniformLocation("earthRadius");
    public final int lightMapUniform = this.getUniformLocation("lightMap");
    public final int clipDistanceUniform = this.getUniformLocation("clipDistance");
    public final int noiseEnabledUniform = this.getUniformLocation("noiseEnabled");
    public final int noiseStepsUniform = this.getUniformLocation("noiseSteps");
    public final int noiseIntensityUniform = this.getUniformLocation("noiseIntensity");
    public final int noiseDropoffUniform = this.getUniformLocation("noiseDropoff");
    public final int whiteWorldUniform = this.getUniformLocation("whiteWorld");

    public LodRenderProgram() {
        super(() -> Shader.loadFile(Config.Client.Advanced.Graphics.AdvancedGraphics.earthCurveRatio.get() != 0 ? VERTEX_CURVE_SHADER_PATH : VERTEX_SHADER_PATH, false, new StringBuilder()).toString(), () -> Shader.loadFile(FRAGMENT_SHADER_PATH, false, new StringBuilder()).toString(), "fragColor", new String[]{"vPosition", "color"});
        int vertexByteCount = LodUtil.LOD_VERTEX_FORMAT.getByteSize();
        this.vao = GLProxy.getInstance().VertexAttributeBufferBindingSupported ? new VertexAttributePostGL43() : new VertexAttributePreGL43();
        this.vao.bind();
        this.vao.setVertexAttribute(0, 0, VertexPointer.addUnsignedShortsPointer(4, false, true));
        this.vao.setVertexAttribute(0, 1, VertexPointer.addUnsignedBytesPointer(4, true, false));
        this.vao.setVertexAttribute(0, 2, VertexPointer.addUnsignedBytesPointer(4, true, true));
        try {
            this.vao.completeAndCheck(vertexByteCount);
        }
        catch (RuntimeException e) {
            System.out.println(LodUtil.LOD_VERTEX_FORMAT);
            throw e;
        }
        if (this.earthRadiusUniform != -1) {
            this.setUniform(this.earthRadiusUniform, 6371000.0f / (float)Config.Client.Advanced.Graphics.AdvancedGraphics.earthCurveRatio.get().intValue());
        }
        this.setUniform(this.noiseEnabledUniform, Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseEnabled.get());
        this.setUniform(this.noiseStepsUniform, Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseSteps.get());
        this.setUniform(this.noiseIntensityUniform, Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseIntensity.get().floatValue());
        this.setUniform(this.noiseDropoffUniform, Config.Client.Advanced.Graphics.NoiseTextureSettings.noiseDropoff.get());
    }

    @Override
    public void bind() {
        super.bind();
        this.vao.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        this.vao.unbind();
    }

    @Override
    public void free() {
        this.vao.free();
        super.free();
    }

    @Override
    public void bindVertexBuffer(int vbo) {
        this.vao.bindBufferToAllBindingPoints(vbo);
    }

    public void unbindVertexBuffer() {
        this.vao.unbindBuffersFromAllBindingPoint();
    }

    @Override
    public void fillUniformData(DhApiRenderParam renderParameters) {
        Mat4f combinedMatrix = new Mat4f(renderParameters.dhProjectionMatrix);
        combinedMatrix.multiply(renderParameters.dhModelViewMatrix);
        super.bind();
        this.setUniform(this.combinedMatUniform, combinedMatrix);
        this.setUniform(this.mircoOffsetUniform, 0.01f);
        this.setUniform(this.lightMapUniform, 0);
        if (this.worldYOffsetUniform != -1) {
            this.setUniform(this.worldYOffsetUniform, (float)renderParameters.worldYOffset);
        }
        this.setUniform(this.whiteWorldUniform, Config.Client.Advanced.Debugging.enableWhiteWorld.get());
        float dhNearClipDistance = RenderUtil.getNearClipPlaneDistanceInBlocks(renderParameters.partialTicks);
        dhNearClipDistance *= 2.0f;
        if (RenderUtil.getHeightBasedNearClipOverride() != -1.0f) {
            dhNearClipDistance = 1.0f;
        }
        this.setUniform(this.clipDistanceUniform, dhNearClipDistance);
    }

    @Override
    public void setModelOffsetPos(Vec3f modelOffsetPos) {
        this.setUniform(this.modelOffsetUniform, modelOffsetPos);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean overrideThisFrame() {
        return true;
    }
}

