/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class BatchGenerator
implements IDhApiWorldGenerator {
    private static final IWrapperFactory FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final int MAX_QUEUED_TASKS_PER_THREAD = 3;
    public AbstractBatchGenerationEnvironmentWrapper generationEnvironment;
    public IDhLevel targetDhLevel;

    public BatchGenerator(IDhLevel targetDhLevel) {
        this.targetDhLevel = targetDhLevel;
        this.generationEnvironment = FACTORY.createBatchGenerator(targetDhLevel);
        LOGGER.info("Batch Chunk Generator initialized");
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public byte getSmallestDataDetailLevel() {
        return 0;
    }

    @Override
    public byte getLargestDataDetailLevel() {
        return 0;
    }

    @Override
    public byte getMinGenerationGranularity() {
        return 4;
    }

    @Override
    public byte getMaxGenerationGranularity() {
        return 6;
    }

    @Override
    public CompletableFuture<Void> generateChunks(int chunkPosMinX, int chunkPosMinZ, byte granularity, byte targetDataDetail, EDhApiDistantGeneratorMode generatorMode, ExecutorService worldGeneratorThreadPool, Consumer<Object[]> resultConsumer) {
        EDhApiWorldGenerationStep targetStep = null;
        switch (generatorMode) {
            case PRE_EXISTING_ONLY: {
                targetStep = EDhApiWorldGenerationStep.BIOMES;
                break;
            }
            case SURFACE: {
                targetStep = EDhApiWorldGenerationStep.SURFACE;
                break;
            }
            case FEATURES: {
                targetStep = EDhApiWorldGenerationStep.FEATURES;
            }
        }
        int genChunkSize = BitShiftUtil.powerOfTwo(granularity - 4);
        Consumer<IChunkWrapper> consumerWrapper = chunkWrapper -> resultConsumer.accept(new Object[]{chunkWrapper});
        try {
            return this.generationEnvironment.generateChunks(chunkPosMinX, chunkPosMinZ, genChunkSize, targetStep, worldGeneratorThreadPool, consumerWrapper);
        }
        catch (Exception e) {
            if (!LodUtil.isInterruptOrReject(e)) {
                LOGGER.error("Error starting future for chunk generation", (Throwable)e);
            }
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public void preGeneratorTaskStart() {
        this.generationEnvironment.updateAllFutures();
    }

    @Override
    public boolean isBusy() {
        int worldGenThreadCount = Math.max(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads.get(), 1);
        int maxWorldGenTaskCount = worldGenThreadCount * 3;
        return this.generationEnvironment.getEventCount() > maxWorldGenTaskCount;
    }

    @Override
    public void close() {
        LOGGER.info(BatchGenerator.class.getSimpleName() + " shutting down...");
        this.generationEnvironment.stop();
    }
}

